/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerId.cpp,v 1.6 2002/08/01 18:45:58 data Exp $
 *
 */

#include "ExManagerId.h"

ExManagerId::ExManagerId()
{
Guard(ExManagerId::ExManagerId())
	m_ExIdCounter=0;
UnGuard
}

ExManagerId::~ExManagerId()
{
Guard(ExManagerId::~ExManagerId())
UnGuard
}

//////////////////////////////////////////////////////////////////////

void ExManagerId::Reset(void)
{
Guard(ExManagerId::Reset(void))
	m_VecObject.clear();	
UnGuard
}

char * ExManagerId::GetAviableName(const char *Name,int occu)
{
Guard(char * ExManagerId::GetAviableName(const char *Name,int occu))
	char *NameB;
	NameB=new char[strlen(Name)];
	sprintf(NameB,"%s",Name);

	if(GetObjectIdByName(NameB)==-1)//new name
	{
		return NameB;
	}else
	{
		//here code to change name
		std::string newname(NameB);
		if(occu>0)
		{
			newname.erase(newname.end()-1,newname.end());
		}
		if(occu>10)
		{
			newname.erase(newname.end()-1,newname.end());
		}
		if(occu>100)
		{
			newname.erase(newname.end()-1,newname.end());
		}
		if(occu>1000)
		{
			newname.erase(newname.end()-1,newname.end());
		}
		if(occu>10000)
		{
			newname.erase(newname.end()-1,newname.end());
		}
		char buffer[255];
		memset(buffer,0,255);
		sprintf(buffer,"%s%d",newname.data(),occu);

		return GetAviableName(buffer,occu+1);
	}
UnGuard
}

IdName ExManagerId::GetNewIdName(char * Name)
{
Guard(IdName ExManagerId::GetNewIdName(char * Name));
	IdName idname;
	idname.first=m_ExIdCounter;
	idname.second=GetAviableName(Name,0);
	m_ExIdCounter++;
	//char buffer[255];
	//sprintf(buffer,"New Id :%ld For:%s",idname.first,idname.second);
	//WriteToConsol(buffer);
	m_VecObject.push_back(idname);
	return idname;
UnGuard
}

ExId ExManagerId::GetObjectIdByName(char * Name)
{
Guard(ExId ExManagerId::GetObjectIdByName(char * Name))
	for(m_ItVecObject=m_VecObject.begin();m_ItVecObject!=m_VecObject.end();m_ItVecObject++)
	{
		if(strcmp(m_ItVecObject->second,Name)==0)
		{
			return m_ItVecObject->first;
		}
	}
	return -1;
UnGuard
}

char * ExManagerId::GetObjectNameById(ExId Id)
{
Guard(char * ExManagerId::GetObjectNameById(ExId Id))
	for(m_ItVecObject=m_VecObject.begin();m_ItVecObject!=m_VecObject.end();m_ItVecObject++)
	{
		if(m_ItVecObject->first==Id)
		{
			return m_ItVecObject->second;
		}
	}
	return "NOTHING";
UnGuard
}

bool ExManagerId::isNameAviable(char * Name)
{
Guard(bool ExManagerId::isNameAviable(char * Name))
	for(m_ItVecObject=m_VecObject.begin();m_ItVecObject!=m_VecObject.end();m_ItVecObject++)
	{
		if(strcmp(m_ItVecObject->second,Name)==0)
		{
			return false;
		}
	}
	return true;
UnGuard
}

bool ExManagerId::RemoveIdName(char * Name)
{
Guard(bool ExManagerId::RemoveIdName(char * Name))
	for(m_ItVecObject=m_VecObject.begin();m_ItVecObject!=m_VecObject.end();m_ItVecObject++)
	{
		if(strcmp(m_ItVecObject->second,Name)==0)
		{
			m_VecObject.erase(m_ItVecObject);
			return true;
		}
	}
	return false;
UnGuard
}

bool ExManagerId::RemoveIdName(ExId Id)
{
Guard(bool ExManagerId::RemoveIdName(ExId Id))
	for(m_ItVecObject=m_VecObject.begin();m_ItVecObject!=m_VecObject.end();m_ItVecObject++)
	{
		if(m_ItVecObject->first==Id)
		{
			m_VecObject.erase(m_ItVecObject);
			return true;
		}
	}
	return false;
UnGuard
}

bool ExManagerId::RecordIdName(ExId Id,char * Name)
{
Guard(bool ExManagerId::RecordIdName(ExId Id,char * Name));
	IdName idname;
	idname.first=Id;
	idname.second=GetAviableName(Name,0);
	m_ExIdCounter++;
	*Consol<<"New Id :"<<idname.first<<"  For:"<<idname.second<<std::endl;
	m_VecObject.push_back(idname);
	return true;
UnGuard
}
