/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerInputGLUT.cpp,v 1.4 2002/08/01 19:37:50 binny Exp $
 *
 */
 
#include "ExManagerInputGLUT.h"

ExManagerInputGLUT::ExManagerInputGLUT(void)
{
Guard(ExManagerInputGLUT::ExManagerInputGLUT(void))
	m_Keyboard=false;
	m_Mouse=false;
	m_SpaceBall=false;
	m_Tablet=false;
	m_Joystick=false;
	m_MouseNumberButtons=0;
	m_SpaceBallNumberButtons=0;
	m_TabletNumberButtons=0;
	m_JoystickNumberButtons=0;
	m_JoystickNumberAxes=0;
UnGuard
}

ExManagerInputGLUT::~ExManagerInputGLUT(void)
{
}

void ExManagerInputGLUT::CheckInput(void)
{
Guard(void ExManagerInputGLUT::CheckInput(void))
	*Consol<<"****************************************"<<endl;
	*Consol<<"*Checking for Hardware                 *"<<endl;
	*Consol<<"****************************************"<<endl;
	if(glutDeviceGet(GLUT_HAS_KEYBOARD)!=0)
	{
		m_Keyboard=true;
	}else
	{
		m_Keyboard=false;
	}
	if(glutDeviceGet(GLUT_HAS_MOUSE)!=0)
	{
		m_Mouse=true;
		m_MouseNumberButtons=glutDeviceGet(GLUT_NUM_MOUSE_BUTTONS);
	}
	else
	{
		m_Mouse=false;
	}
	if(glutDeviceGet(GLUT_HAS_SPACEBALL)!=0)
	{
		m_SpaceBall=true;
		m_SpaceBallNumberButtons=glutDeviceGet(GLUT_NUM_SPACEBALL_BUTTONS);
	}
	else
	{
		m_SpaceBall=false;
	}
	if(glutDeviceGet(GLUT_HAS_TABLET)!=0)
	{
		m_Tablet=true;
		m_TabletNumberButtons=glutDeviceGet(GLUT_NUM_TABLET_BUTTONS);
	}
	else
	{
		m_Tablet=false;
	}
	if(	glutDeviceGet(GLUT_HAS_JOYSTICK)!=0)
	{
		m_Joystick=true;
		m_JoystickNumberButtons=glutDeviceGet(GLUT_JOYSTICK_BUTTONS);
		m_JoystickNumberAxes=glutDeviceGet(GLUT_JOYSTICK_AXES);
	}
	else
	{
		m_Joystick=false;
	}
UnGuard
}

void ExManagerInputGLUT::DisplayAviableInput(void)
{
Guard(void ExManagerInputGLUT::DisplayAviableInput(void))
	*Consol<<"Graphic Render :"<<glGetString(GL_RENDERER)<<endl;
	*Consol<<"Company        :"<<glGetString(GL_VENDOR)<<endl;
	*Consol<<"Version        :"<<glGetString(GL_VERSION)<<endl;
	*Consol<<"Extension      :"<<glGetString(GL_EXTENSIONS)<<endl;
	
	if(m_Keyboard)
		*Consol<<"Keyboard       : available"<<std::endl;
	else
		*Consol<<"Keyboard       : Not available"<<std::endl;
	if(m_Mouse)
		*Consol<<"Mouse          : available "<<m_MouseNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"Mouse          : Not available"<<std::endl;
	if(m_SpaceBall)
		*Consol<<"SpaceBall      : available "<<m_SpaceBallNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"SpaceBall      : Not available"<<std::endl;
	if(m_Tablet)
		*Consol<<"Tablet         : available "<<m_TabletNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"Tablet         : Not available"<<std::endl;
    if(m_Joystick)
		*Consol<<"Joystick       : available "<<m_TabletNumberButtons<<" buttons found"<<std::endl;
	else
		*Consol<<"Joystick       : Not available"<<std::endl;
UnGuard
}

void ExManagerInputGLUT::Key(unsigned char key,int x,int y)
{
	// the most powerfull tool to get a scancode ;)
	//std::cout << (int)key << std::endl;
	switch(key)
	{
	case 8:ManagerCommand->InputCommand(KEYBOARD_DOWN_BACKSPACE);break;
	case 21:ManagerCommand->InputCommand(KEYBOARD_DOWN_CTRL_U);break;
	case 9:ManagerCommand->InputCommand(KEYBOARD_DOWN_TAB);break;
	case 27:ManagerCommand->InputCommand(KEYBOARD_DOWN_ESC);break;
	case 178:ManagerCommand->InputCommand(KEYBOARD_DOWN_EXP);break;
	case 13	:ManagerCommand->InputCommand(KEYBOARD_DOWN_ENTER);break;
	case 32	:ManagerCommand->InputCommand(KEYBOARD_DOWN_SPACE);break;
	case '_':ManagerCommand->InputCommand(KEYBOARD_DOWN__);break;
	case ':':ManagerCommand->InputCommand(KEYBOARD_DOWN_2POINTS);break;
	case '.':ManagerCommand->InputCommand(KEYBOARD_DOWN_POINT);break;
	case '0':ManagerCommand->InputCommand(KEYBOARD_DOWN_0);break;
	case '1':ManagerCommand->InputCommand(KEYBOARD_DOWN_1);break;
	case '2':ManagerCommand->InputCommand(KEYBOARD_DOWN_2);break;
	case '3':ManagerCommand->InputCommand(KEYBOARD_DOWN_3);break;
	case '4':ManagerCommand->InputCommand(KEYBOARD_DOWN_4);break;
	case '5':ManagerCommand->InputCommand(KEYBOARD_DOWN_5);break;
	case '6':ManagerCommand->InputCommand(KEYBOARD_DOWN_6);break;
	case '7':ManagerCommand->InputCommand(KEYBOARD_DOWN_7);break;
	case '8':ManagerCommand->InputCommand(KEYBOARD_DOWN_8);break;
	case '9':ManagerCommand->InputCommand(KEYBOARD_DOWN_9);break;
	case 'a':ManagerCommand->InputCommand(KEYBOARD_DOWN_A);break;
	case 'A':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_A);break;
	case 'b':ManagerCommand->InputCommand(KEYBOARD_DOWN_B);break;
	case 'B':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_B);break;
	case 'c':ManagerCommand->InputCommand(KEYBOARD_DOWN_C);break;
	case 'C':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_C);break;
	case 'd':ManagerCommand->InputCommand(KEYBOARD_DOWN_D);break;
	case 'D':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_D);break;
	case 'e':ManagerCommand->InputCommand(KEYBOARD_DOWN_E);break;
	case 'E':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_E);break;
	case 'f':ManagerCommand->InputCommand(KEYBOARD_DOWN_F);break;
	case 'F':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_F);break;
	case 'g':ManagerCommand->InputCommand(KEYBOARD_DOWN_G);break;
	case 'G':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_G);break;
	case 'h':ManagerCommand->InputCommand(KEYBOARD_DOWN_H);break;
	case 'H':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_H);break;
	case 'i':ManagerCommand->InputCommand(KEYBOARD_DOWN_I);break;
	case 'I':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_I);break;
	case 'j':ManagerCommand->InputCommand(KEYBOARD_DOWN_J);break;
	case 'J':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_J);break;
	case 'k':ManagerCommand->InputCommand(KEYBOARD_DOWN_K);break;
	case 'K':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_K);break;
	case 'l':ManagerCommand->InputCommand(KEYBOARD_DOWN_L);break;
	case 'L':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_L);break;
	case 'm':ManagerCommand->InputCommand(KEYBOARD_DOWN_M);break;
	case 'M':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_M);break;
	case 'n':ManagerCommand->InputCommand(KEYBOARD_DOWN_N);break;
	case 'N':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_N);break;
	case 'o':ManagerCommand->InputCommand(KEYBOARD_DOWN_O);break;
	case 'O':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_O);break;
	case 'p':ManagerCommand->InputCommand(KEYBOARD_DOWN_P);break;
	case 'P':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_P);break;
	case 'q':ManagerCommand->InputCommand(KEYBOARD_DOWN_Q);break;
	case 'Q':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_Q);break;
	case 'r':ManagerCommand->InputCommand(KEYBOARD_DOWN_R);break;
	case 'R':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_R);break;
	case 's':ManagerCommand->InputCommand(KEYBOARD_DOWN_S);break;
	case 'S':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_S);break;
	case 't':ManagerCommand->InputCommand(KEYBOARD_DOWN_T);break;
	case 'T':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_T);break;
	case 'u':ManagerCommand->InputCommand(KEYBOARD_DOWN_U);break;
	case 'U':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_U);break;
	case 'v':ManagerCommand->InputCommand(KEYBOARD_DOWN_V);break;
	case 'V':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_V);break;
	case 'w':ManagerCommand->InputCommand(KEYBOARD_DOWN_W);break;
	case 'W':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_W);break;
	case 'x':ManagerCommand->InputCommand(KEYBOARD_DOWN_X);break;
	case 'X':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_X);break;
	case 'y':ManagerCommand->InputCommand(KEYBOARD_DOWN_Y);break;
	case 'Y':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_Y);break;
	case 'z':ManagerCommand->InputCommand(KEYBOARD_DOWN_Z);break;
	case 'Z':ManagerCommand->InputCommand(KEYBOARD_DOWN_M_Z);break;
	}
	ManagerCommand->SetMousePosition(x,y);
}

void ExManagerInputGLUT::KeyUp(unsigned char key, int x, int y)
{
	switch(key)
	{
	case 8:ManagerCommand->InputCommand(KEYBOARD_UP_BACKSPACE);break;
	case 27:ManagerCommand->InputCommand(KEYBOARD_UP_ESC);break;
	case 178:ManagerCommand->InputCommand(KEYBOARD_UP_EXP);break;
	case 32	:ManagerCommand->InputCommand(KEYBOARD_UP_SPACE);break;
	case ':':ManagerCommand->InputCommand(KEYBOARD_UP_2POINTS);break;
	case '.':ManagerCommand->InputCommand(KEYBOARD_UP_POINT);break;
	case '_':ManagerCommand->InputCommand(KEYBOARD_UP__);break;
	case '0':ManagerCommand->InputCommand(KEYBOARD_UP_0);break;
	case '1':ManagerCommand->InputCommand(KEYBOARD_UP_1);break;
	case '2':ManagerCommand->InputCommand(KEYBOARD_UP_2);break;
	case '3':ManagerCommand->InputCommand(KEYBOARD_UP_3);break;
	case '4':ManagerCommand->InputCommand(KEYBOARD_UP_4);break;
	case '5':ManagerCommand->InputCommand(KEYBOARD_UP_5);break;
	case '6':ManagerCommand->InputCommand(KEYBOARD_UP_6);break;
	case '7':ManagerCommand->InputCommand(KEYBOARD_UP_7);break;
	case '8':ManagerCommand->InputCommand(KEYBOARD_UP_8);break;
	case '9':ManagerCommand->InputCommand(KEYBOARD_UP_9);break;
	case 'a':ManagerCommand->InputCommand(KEYBOARD_UP_A);break;
	case 'A':ManagerCommand->InputCommand(KEYBOARD_UP_M_A);break;
	case 'b':ManagerCommand->InputCommand(KEYBOARD_UP_B);break;
	case 'B':ManagerCommand->InputCommand(KEYBOARD_UP_M_B);break;
	case 'c':ManagerCommand->InputCommand(KEYBOARD_UP_C);break;
	case 'C':ManagerCommand->InputCommand(KEYBOARD_UP_M_C);break;
	case 'd':ManagerCommand->InputCommand(KEYBOARD_UP_D);break;
	case 'D':ManagerCommand->InputCommand(KEYBOARD_UP_M_D);break;
	case 'e':ManagerCommand->InputCommand(KEYBOARD_UP_E);break;
	case 'E':ManagerCommand->InputCommand(KEYBOARD_UP_M_E);break;
	case 'f':ManagerCommand->InputCommand(KEYBOARD_UP_F);break;
	case 'F':ManagerCommand->InputCommand(KEYBOARD_UP_M_F);break;
	case 'g':ManagerCommand->InputCommand(KEYBOARD_UP_G);break;
	case 'G':ManagerCommand->InputCommand(KEYBOARD_UP_M_G);break;
	case 'h':ManagerCommand->InputCommand(KEYBOARD_UP_H);break;
	case 'H':ManagerCommand->InputCommand(KEYBOARD_UP_M_H);break;
	case 'i':ManagerCommand->InputCommand(KEYBOARD_UP_I);break;
	case 'I':ManagerCommand->InputCommand(KEYBOARD_UP_M_I);break;
	case 'j':ManagerCommand->InputCommand(KEYBOARD_UP_J);break;
	case 'J':ManagerCommand->InputCommand(KEYBOARD_UP_M_J);break;
	case 'k':ManagerCommand->InputCommand(KEYBOARD_UP_K);break;
	case 'K':ManagerCommand->InputCommand(KEYBOARD_UP_M_K);break;
	case 'l':ManagerCommand->InputCommand(KEYBOARD_UP_L);break;
	case 'L':ManagerCommand->InputCommand(KEYBOARD_UP_M_L);break;
	case 'm':ManagerCommand->InputCommand(KEYBOARD_UP_M);break;
	case 'M':ManagerCommand->InputCommand(KEYBOARD_UP_M_M);break;
	case 'n':ManagerCommand->InputCommand(KEYBOARD_UP_N);break;
	case 'N':ManagerCommand->InputCommand(KEYBOARD_UP_M_N);break;
	case 'o':ManagerCommand->InputCommand(KEYBOARD_UP_O);break;
	case 'O':ManagerCommand->InputCommand(KEYBOARD_UP_M_O);break;
	case 'p':ManagerCommand->InputCommand(KEYBOARD_UP_P);break;
	case 'P':ManagerCommand->InputCommand(KEYBOARD_UP_M_P);break;
	case 'q':ManagerCommand->InputCommand(KEYBOARD_UP_Q);break;
	case 'Q':ManagerCommand->InputCommand(KEYBOARD_UP_M_Q);break;
	case 'r':ManagerCommand->InputCommand(KEYBOARD_UP_R);break;
	case 'R':ManagerCommand->InputCommand(KEYBOARD_UP_M_R);break;
	case 's':ManagerCommand->InputCommand(KEYBOARD_UP_S);break;
	case 'S':ManagerCommand->InputCommand(KEYBOARD_UP_M_S);break;
	case 't':ManagerCommand->InputCommand(KEYBOARD_UP_T);break;
	case 'T':ManagerCommand->InputCommand(KEYBOARD_UP_M_T);break;
	case 'u':ManagerCommand->InputCommand(KEYBOARD_UP_U);break;
	case 'U':ManagerCommand->InputCommand(KEYBOARD_UP_M_U);break;
	case 'v':ManagerCommand->InputCommand(KEYBOARD_UP_V);break;
	case 'V':ManagerCommand->InputCommand(KEYBOARD_UP_M_V);break;
	case 'w':ManagerCommand->InputCommand(KEYBOARD_UP_W);break;
	case 'W':ManagerCommand->InputCommand(KEYBOARD_UP_M_W);break;
	case 'x':ManagerCommand->InputCommand(KEYBOARD_UP_X);break;
	case 'X':ManagerCommand->InputCommand(KEYBOARD_UP_M_X);break;
	case 'y':ManagerCommand->InputCommand(KEYBOARD_UP_Y);break;
	case 'Y':ManagerCommand->InputCommand(KEYBOARD_UP_M_Y);break;
	case 'z':ManagerCommand->InputCommand(KEYBOARD_UP_Z);break;
	case 'Z':ManagerCommand->InputCommand(KEYBOARD_UP_M_Z);break;
	}
ManagerCommand->SetMousePosition(x,y);	
}

void ExManagerInputGLUT::KeySpe(int key,int x,int y)
{
Guard(void ExManagerInputGLUT::KeySpe(int key,int x,int y));
	switch (key) 
	{
	case GLUT_KEY_LEFT :ManagerCommand->InputCommand(KEYBOARD_DOWN_ARROW_LEFT);break;
	case GLUT_KEY_RIGHT :ManagerCommand->InputCommand(KEYBOARD_DOWN_ARROW_RIGHT);break;
	case GLUT_KEY_UP :ManagerCommand->InputCommand(KEYBOARD_DOWN_ARROW_UP);break;
	case GLUT_KEY_DOWN :ManagerCommand->InputCommand(KEYBOARD_DOWN_ARROW_DOWN);break;
	case GLUT_KEY_F1:ManagerCommand->InputCommand(KEYBOARD_DOWN_F1);break; 
	case GLUT_KEY_F2:ManagerCommand->InputCommand(KEYBOARD_DOWN_F2);break; 
	case GLUT_KEY_F3:ManagerCommand->InputCommand(KEYBOARD_DOWN_F3);break; 
	case GLUT_KEY_F4:ManagerCommand->InputCommand(KEYBOARD_DOWN_F4);break; 	
	case GLUT_KEY_F5:ManagerCommand->InputCommand(KEYBOARD_DOWN_F5);break; 
	case GLUT_KEY_F6:ManagerCommand->InputCommand(KEYBOARD_DOWN_F6);break; 	
	case GLUT_KEY_F7:ManagerCommand->InputCommand(KEYBOARD_DOWN_F7);break; 
	case GLUT_KEY_F8:ManagerCommand->InputCommand(KEYBOARD_DOWN_F8);break; 	
	case GLUT_KEY_F9:ManagerCommand->InputCommand(KEYBOARD_DOWN_F9);break; 
	case GLUT_KEY_F10:ManagerCommand->InputCommand(KEYBOARD_DOWN_F10);break; 	
	case GLUT_KEY_F11:ManagerCommand->InputCommand(KEYBOARD_DOWN_F11);break; 
	case GLUT_KEY_F12:ManagerCommand->InputCommand(KEYBOARD_DOWN_F12);break;
	case GLUT_KEY_PAGE_UP:ManagerCommand->InputCommand(KEYBOARD_DOWN_PAGE_UP);break; 
	case GLUT_KEY_PAGE_DOWN:ManagerCommand->InputCommand(KEYBOARD_DOWN_PAGE_DOWN);break; 	
	case GLUT_KEY_END:ManagerCommand->InputCommand(KEYBOARD_DOWN_END);break; 
	case GLUT_KEY_HOME:ManagerCommand->InputCommand(KEYBOARD_DOWN_HOME);break; 	
	case GLUT_KEY_INSERT:ManagerCommand->InputCommand(KEYBOARD_DOWN_INSERT);break; 
	}
	ManagerCommand->SetMousePosition(x,y);
UnGuard
}

void ExManagerInputGLUT::KeySpeUp(int key, int x, int y)
{
	switch (key) 
	{
	case GLUT_KEY_LEFT :ManagerCommand->InputCommand(KEYBOARD_UP_ARROW_LEFT);break;
	case GLUT_KEY_RIGHT :ManagerCommand->InputCommand(KEYBOARD_UP_ARROW_RIGHT);break;
	case GLUT_KEY_UP :ManagerCommand->InputCommand(KEYBOARD_UP_ARROW_UP);break;
	case GLUT_KEY_DOWN:ManagerCommand->InputCommand(KEYBOARD_UP_ARROW_DOWN);break;
	case GLUT_KEY_F1:ManagerCommand->InputCommand(KEYBOARD_UP_F1);break; 
	case GLUT_KEY_F2:ManagerCommand->InputCommand(KEYBOARD_UP_F2);break; 
	case GLUT_KEY_F3:ManagerCommand->InputCommand(KEYBOARD_UP_F3);break; 
	case GLUT_KEY_F4:ManagerCommand->InputCommand(KEYBOARD_UP_F4);break; 	
	case GLUT_KEY_F5:ManagerCommand->InputCommand(KEYBOARD_UP_F5);break; 
	case GLUT_KEY_F6:ManagerCommand->InputCommand(KEYBOARD_UP_F6);break; 	
	case GLUT_KEY_F7:ManagerCommand->InputCommand(KEYBOARD_UP_F7);break; 
	case GLUT_KEY_F8:ManagerCommand->InputCommand(KEYBOARD_UP_F8);break; 	
	case GLUT_KEY_F9:ManagerCommand->InputCommand(KEYBOARD_UP_F9);break; 
	case GLUT_KEY_F10:ManagerCommand->InputCommand(KEYBOARD_UP_F10);break; 	
	case GLUT_KEY_F11:ManagerCommand->InputCommand(KEYBOARD_UP_F11);break; 
	case GLUT_KEY_F12:ManagerCommand->InputCommand(KEYBOARD_UP_F12);break;
	case GLUT_KEY_PAGE_UP:ManagerCommand->InputCommand(KEYBOARD_UP_PAGE_UP);break; 
	case GLUT_KEY_PAGE_DOWN:ManagerCommand->InputCommand(KEYBOARD_UP_PAGE_DOWN);break; 	
	case GLUT_KEY_END:ManagerCommand->InputCommand(KEYBOARD_UP_END);break; 
	case GLUT_KEY_HOME:ManagerCommand->InputCommand(KEYBOARD_UP_HOME);break; 	
	case GLUT_KEY_INSERT:ManagerCommand->InputCommand(KEYBOARD_UP_INSERT);break; 
	}
	ManagerCommand->SetMousePosition(x,y);
}

void ExManagerInputGLUT::Mouse(int button, int state, int x, int y)
{
	//GLUT_UP ou GLUT_DOWN
	switch(button)
	{
	case GLUT_LEFT_BUTTON:
		if(state==GLUT_UP)
		{
			ManagerCommand->InputCommand(MOUSE_LEFT_BUTTON_UP);
		}
		if(state==GLUT_DOWN)
		{
			ManagerCommand->InputCommand(MOUSE_LEFT_BUTTON_DOWN);
		}
		break;
	case GLUT_MIDDLE_BUTTON:
		if(state==GLUT_UP)
		{
			ManagerCommand->InputCommand(MOUSE_MIDDLE_BUTTON_UP);
		}
		if(state==GLUT_DOWN)
		{
			ManagerCommand->InputCommand(MOUSE_MIDDLE_BUTTON_DOWN);
		}
		break;
	case GLUT_RIGHT_BUTTON:
		if(state==GLUT_UP)
		{
			ManagerCommand->InputCommand(MOUSE_RIGHT_BUTTON_UP);
		}
		if(state==GLUT_DOWN)
		{
			ManagerCommand->InputCommand(MOUSE_RIGHT_BUTTON_DOWN);
		}
		break;
	}
	ManagerCommand->SetMousePosition(x,y);
}
void ExManagerInputGLUT::Focus(int state)
{
Guard(void QCManagerInput::MouseFocus(int state))
	switch(state)
	{
	case GLUT_LEFT :
		break;
	case GLUT_ENTERED :
		break;
	}
UnGuard
}
void ExManagerInputGLUT::MouseMotion(int x, int y)
{
Guard(void QCManagerInput::MouseMotion(int x, int y))
UnGuard
}
void ExManagerInputGLUT::MousePassiveMotion(int x, int y)
{
Guard(void QCManagerInput::MousePassiveMotion(int x, int y))
UnGuard
}
void ExManagerInputGLUT::SpaceballMotion(int x, int y, int z)
{
Guard(void QCManagerInput::SpaceballMotion(int x, int y, int z))
UnGuard
}
void ExManagerInputGLUT::SpaceballRotate(int x, int y, int z)
{
Guard(void QCManagerInput::SpaceballRotate(int x, int y, int z))
UnGuard
}
void ExManagerInputGLUT::TabletMotion(int x, int y)
{
Guard(void QCManagerInput::TabletMotion(int x, int y))
UnGuard
}
void ExManagerInputGLUT::TabletButton(int button, int state, int x, int y)
{
Guard(void QCManagerInput::TabletButton(int button, int state, int x, int y))
UnGuard
}
