/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerInterface.cpp,v 1.6 2002/08/01 18:45:58 data Exp $
 *
 */

#include "ExManagerInterface.h"

ExManagerInterface::ExManagerInterface(void)
{
}

ExManagerInterface::~ExManagerInterface(void)
{
}

void ExManagerInterface::Reset(void)
{
Guard(void ExManagerInterface::Reset(void))
	m_VecInterface.clear();
UnGuard
}

void ExManagerInterface::init(void)
{
Guard(void ExManagerInterface::init(void))

UnGuard
}

bool ExManagerInterface::LoadInterface(const char * FileName)
{
Guard(bool ExManagerInterface::LoadInterface(const char * FileName))
	ExCInterface Inter;
	Inter.SetManagerWindow(ManagerWindow);
	Inter.SetManagerTexture(ManagerTexture);
	Inter.WriteToConsol=WriteToConsol;
	Inter.Consol=Consol;
	if(Inter.LoadInterface(FileName))
	{
		m_VecInterface.push_back(Inter);
		return true;
	}
	return false;
UnGuard
}

void ExManagerInterface::DrawInterface(void)
{
Guard(void ExManagerInterface::DrawInterface(void))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		if(m_ItVecInterface->GetInterfaceState())
		{
			m_ItVecInterface->DrawInterface();
		}
	}
UnGuard
}

void ExManagerInterface::ShowRegion(void)
{
Guard(void ExManagerInterface::ShowRegion(void))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		m_ItVecInterface->ShowRegion();
	}
UnGuard
}

void ExManagerInterface::HideRegion(void)
{
Guard(void ExManagerInterface::HideRegion(void))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		m_ItVecInterface->HideRegion();
	}
UnGuard
}

SAction ExManagerInterface::InputCommand(int command,int mousex,int mousey)
{
Guard(int ExManagerInterface::InputCommand(int command,int mousex,int mousey))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		if(m_ItVecInterface->GetInterfaceState())
		{
			
			return m_ItVecInterface->InputCommand(command,mousex,mousey);
			
		}
	}
	return NOTHING;
UnGuard
}

int ExManagerInterface::EnableInterface(char *param)
{
Guard(int ExManagerInterface::EnableInterface(char *param))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		
	}
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::DisableInterface(char *param)
{
Guard(int ExManagerInterface::DisableInterface(char *param))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		if(strcmp(m_ItVecInterface->GetInterfaceName(),param)==0)
		{
			m_ItVecInterface->DisableInterface();
		}
	}
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::EnableAllInterface(void)
{
Guard(int ExManagerInterface::EnableAllInterface(void))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		m_ItVecInterface->EnableInterface();
	}
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::DisableAllInterface(void)
{
Guard(int ExManagerInterface::DisableAllInterface(void))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		m_ItVecInterface->DisableInterface();
	}
	return GetNumberEnableInterface();
UnGuard
}

int ExManagerInterface::GetNumberEnableInterface(void)
{
Guard(int ExManagerInterface::GetNumberEnableInterface(void))
	int ret=0;
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
			if(m_ItVecInterface->GetInterfaceState())ret++;
	}
	return ret;
UnGuard
}

void ExManagerInterface::ListInterface(void)
{
Guard(void ExManagerInterface::ListInterface(void))
	for(m_ItVecInterface=m_VecInterface.begin();m_ItVecInterface!=m_VecInterface.end();m_ItVecInterface++)
	{
		if(m_ItVecInterface->GetInterfaceState())
		{
			*Consol<<"Interface :"<<m_ItVecInterface->GetInterfaceName()<<"State : enable"<<std::endl;
		}else
		{
			*Consol<<"Interface :"<<m_ItVecInterface->GetInterfaceName()<<"State : Disable"<<std::endl;
		}
	}
UnGuard
}

