/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerLight.cpp,v 1.5 2002/08/01 01:18:22 data Exp $
 *
 */

#include "ExManagerLight.h"

ExManagerLight::ExManagerLight(void)
{
Guard(ExManagerLight::ExManagerLight(void))
UnGuard
}


ExManagerLight::~ExManagerLight(void)
{
Guard(ExManagerLight::~ExManagerLight(void))
UnGuard
}


void  ExManagerLight::Reset(void)
{
Guard(void  ExManagerLight::Reset(void))
	m_VecLight.clear();
UnGuard
}


void  ExManagerLight::Init(void)
{
Guard(void  ExManagerLight::Init(void))
UnGuard
}


bool  ExManagerLight::Init(char * FileName)
{
Guard(bool  ExManagerLight::Init(char * FileName))
	//openf file and load object
	return true;
UnGuard
}


ExId  ExManagerLight::NewObject(void)
{
Guard(ExId  ExManagerLight::NewObject(void))
	ExCLight NewLight;
	m_VecLight.push_back(NewLight);
	return NewLight.GetId();
UnGuard
}


ExCLight *  ExManagerLight::Get(char * Name)
{
Guard(ExCLight * ExManagerLight::Get(char * Name))
	int i=0;
	for(m_ItVecLight=m_VecLight.begin();m_ItVecLight!=m_VecLight.end();m_ItVecLight++,i++)
	{
		if(strcmp(m_ItVecLight->GetName(),Name)==0)
		{
			return &m_VecLight.at(i);
		}
	}
	return NULL;
UnGuard
}


ExCLight * ExManagerLight::Get(ExId Id)
{
Guard(ExCLight * ExManagerLight::Get(ExId Id))
	int i=0;
	for(m_ItVecLight=m_VecLight.begin();m_ItVecLight!=m_VecLight.end();m_ItVecLight++,i++)
	{
		if(m_ItVecLight->GetId()==Id)
		{
			return &m_VecLight.at(i);
		}
	}
	return NULL;	
UnGuard
}


ExId  ExManagerLight::Add(ExCLight Object)
{
Guard(ExId ExManagerLight::Add(ExCLight Object))
	m_VecLight.push_back(Object);
	return Object.GetId();
UnGuard
}


bool  ExManagerLight::Remove(ExId Id)
{
Guard(bool ExManagerLight::Remove(ExId Id))
	for(m_ItVecLight=m_VecLight.begin();m_ItVecLight!=m_VecLight.end();m_ItVecLight++)
	{
		if(m_ItVecLight->GetId()==Id)
		{
			m_VecLight.erase(m_ItVecLight);
			return true;
		}
	}
	return false;
UnGuard
}


ExId  ExManagerLight::GetIdByName(char *Name)
{
Guard(ExId ExManagerLight::GetIdByName(char *Name))
	for(m_ItVecLight=m_VecLight.begin();m_ItVecLight!=m_VecLight.end();m_ItVecLight++)
	{
		if(strcmp(m_ItVecLight->GetName(),Name)==0)
		{
			return m_ItVecLight->GetId();
		}
	}
	return -1;
UnGuard
}


char * ExManagerLight::GetNameById(ExId Id)
{
Guard(char * ExManagerLight::GetNameById(ExId Id))
	for(m_ItVecLight=m_VecLight.begin();m_ItVecLight!=m_VecLight.end();m_ItVecLight++)
	{
		if(m_ItVecLight->GetId()==Id)
		{
			return m_ItVecLight->GetName();
		}
	}
	return NULL;
UnGuard
}

