/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerMap.cpp,v 1.5 2002/08/01 18:45:58 data Exp $
 *
 */

#include "ExManagerMap.h"

ExManagerMap::ExManagerMap(void)
{
	MapLoaded=false;
}

ExManagerMap::~ExManagerMap(void)
{
}

void ExManagerMap::Reset(void)
{
	MapLoaded=false;
}

void ExManagerMap::LoadMap(const char * FileName)
{
Guard(ExManagerMap::LoadMap(const char * ))
	Map=new ExCMap();
	Map->SetManagerTexture(ManagerTexture);
	Map->Consol=Consol;
	Map->WriteToConsol=WriteToConsol;
	Map->LoadMap(FileName);
	MapLoaded=true;
UnGuard
}

void ExManagerMap::Draw(void)
{
Guard(void ExManagerMap::Draw(void))
	if(MapLoaded)
	{
		Map->Draw();
	}
UnGuard
}
