/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerOutput.cpp,v 1.13 2002/08/06 16:52:59 binny Exp $
 *
 */

#include "ExManagerOutput.h"

ExManagerOutput::ExManagerOutput(void)
{
Guard(ExManagerOutput::ExManagerOutput(void))

UnGuard
}

ExManagerOutput::~ExManagerOutput(void)
{
Guard(ExManagerOutput::~ExManagerOutput(void))
UnGuard
}

void ExManagerOutput::Reset(void)
{
	Init();
}

void ExManagerOutput::Init(void)
{
Guard(ExManagerOutput::Init(void))
 	glShadeModel(GL_SMOOTH);							// Enable Smooth Shading
	glClearColor(0.0f, 0.0f, 0.0f, 0.5f);				// Black Background
	glClearDepth(1.0f);									// Depth Buffer Setup
	glDepthFunc(GL_LEQUAL);								// The Type Of Depth Testing To Do
	glCullFace(GL_BACK);
	glEnable(GL_CULL_FACE);
	//glEnable(GL_LIGHTING);
	glEnable(GL_COLOR_MATERIAL );
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_AUTO_NORMAL);
	glEnable(GL_NORMALIZE);
	glEnable(GL_ALPHA_TEST);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE,GL_FALSE);
	glLineWidth(1.5);
UnGuard
}

void ExManagerOutput::Reshape(int w,int h)
{
Guard(ExManagerOutput::Reshape(int w,int h))
	ManagerWindow->SetResolution(w,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glViewport(0,0,ManagerWindow->GetResolutionX(),ManagerWindow->GetResolutionY());
	gluPerspective(ManagerCam->GetCurrentCam()->GetZoom(),
		(1.0f *ManagerWindow->GetResolutionX() / ManagerWindow->GetResolutionY()),
		ManagerCam->GetCurrentCam()->GetClipNear(),
		ManagerCam->GetCurrentCam()->GetClipFar());
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	ManagerCam->GetCurrentCam()->Draw();
UnGuard
}

void ExManagerOutput::DrawScene(void)
{
Guard(ExManagerOutput::DrawScene(void))
int plok=0;
	plok++;
	glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    //0 Command
	ManagerCommand->ApplyAction();
	//1 Animation
	//2 Collision detection
	//3 Camera Postion and vue
    ManagerCam->Draw(ManagerWindow->GetResolutionX(),ManagerWindow->GetResolutionY());

	if(ManagerWindow->GetMotionBlurState()){ManagerWindow->MotionBlur();}

	//4 Draw Map
	ManagerMap->Draw();
	//5 Call Pvs to draw object
	ManagerPVS->DrawAllObject();
	
	//6 Draw interface 
	if(ManagerWindow->GetInterfaceState()){ManagerInterface->DrawInterface();}
	if(ManagerWindow->GetFpsState ()) { ManagerWindow->ShowFps(); }
	if(ManagerWindow->GetGrilleState()){glCallList(GRILLE);}
	if(ManagerWindow->GetNetstatState()){ManagerWindow->ShowNetStat();}
	
	
	
	//7 Draw Spirit
	ManagerWindow->Specialeffect();
	//8 Draw Menu
	//if(ManagerWindow->GetMenuState()){ManagerMenu->DrawMenu();}
	//9 Draw console
	if(ManagerWindow->GetConsoleState()){ManagerConsole->DrawConsole();}	
	glutSwapBuffers();
UnGuard
}

