/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerPVS.cpp,v 1.7 2002/06/16 12:43:00 data Exp $
 *
 */

#include "ExManagerPVS.h"

ExManagerPVS::ExManagerPVS(void)
{
	Reset();
}

ExManagerPVS::~ExManagerPVS(void)
{
}

void ExManagerPVS::DrawAllObject(void)
{
Guard(void ExManagerPVS::DrawAllObject(void))
	uint i=0;
	Frustrum.CalculateFrustum();
	glPushMatrix();
	//---------------------------
	//OBJECT
	//---------------------------
	glRotatef(-90,1,0,0);//just for align with 3ds max cord
	while (i < m_VecEntite->size())
	{
		m_VecEntite->at(i)->Draw();
		i++;
	}
	glPopMatrix();
	//---------------------------
	//PARTICULE SYSTEM
	//---------------------------
	glPushMatrix();
	i=0;
	while(i<m_VecSystemeParticule->size())
	{
		m_VecSystemeParticule->at(i)->Draw();
		i++;
	}
	glPopMatrix();
UnGuard
}


void ExManagerPVS::Reset(void)
{
	m_VecEntite= new std::vector<ExCEntite *>;
	m_VecSystemeParticule = new std::vector<ExCSystemeParticule *>;
}
