/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerParticuleSystem.cpp,v 1.10 2002/08/01 18:45:58 data Exp $
 *
 */
#include "ExManagerParticuleSystem.h"

ExManagerParticuleSystem::ExManagerParticuleSystem(void)
{
Guard(ExManagerParticuleSystem::ExManagerParticuleSystem(void))
	m_VecParticuleSysteme = new std::vector<ExCSystemeParticule>;
	m_VecPParticuleSysteme = new std::vector<ExCSystemeParticule *>;
UnGuard
}


ExManagerParticuleSystem::~ExManagerParticuleSystem(void)
{
Guard(ExManagerParticuleSystem::~ExManagerParticuleSystem(void))
UnGuard
}


bool ExManagerParticuleSystem::LoadParticuleSysteme(const char * FileName)
{
Guard(bool ExManagerParticuleSystem::LoadParticuleSysteme(const char * FileName))
	ExCSystemeParticule	systeme;
	systeme.WriteToConsol=WriteToConsol;
	if(systeme.LoadParticuleSysteme(FileName))
	{
		m_VecParticuleSysteme->push_back(systeme);
		CreateVecPobject();
		return true;
	}
	return false;
UnGuard
}

int ExManagerParticuleSystem::StartParticuleSysteme(char *param)
{
Guard(int ExManagerParticuleSystem::StartParticuleSysteme(char *param))
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++)
	{
		if(strcmp(m_ItVecParticuleSysteme->GetParticuleSystemeName(),param)==0)
		{
			m_ItVecParticuleSysteme->Start();
		}
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}

int ExManagerParticuleSystem::StopParticuleSysteme(char *param)
{
Guard(int ExManagerParticuleSystem::StopParticuleSysteme(char *param))
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++)
	{
		if(strcmp(m_ItVecParticuleSysteme->GetParticuleSystemeName(),param)==0)
		{
			m_ItVecParticuleSysteme->Stop();
		}
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}

int ExManagerParticuleSystem::PauseParticuleSysteme(char *param)
{
Guard(int ExManagerParticuleSystem::PauseParticuleSysteme(char *param))
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++)
	{
		if(strcmp(m_ItVecParticuleSysteme->GetParticuleSystemeName(),param)==0)
		{
			m_ItVecParticuleSysteme->Pause();
		}
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}

int ExManagerParticuleSystem::StartAllParticuleSysteme(void)
{
Guard(int ExManagerParticuleSystem::StartAllParticuleSysteme(void))
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++)
	{
		m_ItVecParticuleSysteme->Start();
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}

int ExManagerParticuleSystem::StopAllParticuleSysteme(void)
{
Guard(int ExManagerParticuleSystem::StopAllParticuleSysteme(void))
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++)
	{
		m_ItVecParticuleSysteme->Stop();
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}
	
int ExManagerParticuleSystem::PauseAllParticuleSysteme(void)
{
Guard(int ExManagerParticuleSystem::PauseAllParticuleSysteme(void))
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++)
	{
		m_ItVecParticuleSysteme->Pause();
	}
	return GetNumberEnableParticuleSysteme();
UnGuard
}

void ExManagerParticuleSystem::ListParticuleSysteme(void)
{
Guard(void ExManagerParticuleSystem::ListParticuleSysteme(void))
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++)
	{
		if(m_ItVecParticuleSysteme->GetParticuleSystemeState())
		{
			*Consol<<"ParticuleSysteme :"<<m_ItVecParticuleSysteme->GetParticuleSystemeName()<<" State : Enable"<<std::endl; 
		}else
		{
			*Consol<<"ParticuleSysteme :"<<m_ItVecParticuleSysteme->GetParticuleSystemeName()<<" State : Disable"<<std::endl;
		}
	}
UnGuard
}

void ExManagerParticuleSystem::CreateVecPobject(void)
{
Guard(void ExManagerParticuleSystem::CreateVecPobject(void))	
	m_VecPParticuleSysteme->clear();
	int i=0;
	for(m_ItVecParticuleSysteme=m_VecParticuleSysteme->begin();m_ItVecParticuleSysteme!=m_VecParticuleSysteme->end();m_ItVecParticuleSysteme++,i++)
	{
		m_VecPParticuleSysteme->push_back(&m_VecParticuleSysteme->at(i));
	}
	*Consol<<"Number of Particule syteme :"<<m_VecPParticuleSysteme->size()<<std::endl;
UnGuard
}
