/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerSound.cpp,v 1.10 2002/08/01 18:45:58 data Exp $
 *
 */

#include "ExManagerSound.h"

ExManagerSound::ExManagerSound (void) {

}

ExManagerSound::~ExManagerSound (void) {
	alcDestroyContext (context_id);
}

bool ExManagerSound::Init (void) {
Guard (void ExManagerSound::init (void))

	dev = alcOpenDevice (NULL);
	if (dev == NULL) {
		*Consol<<"Can not initialize Audio device"<<std::endl;
		return false;
	}
	
	context_id = alcCreateContext (dev, NULL);
	if (context_id == NULL) {
		alcCloseDevice (dev);
		*Consol<<"Can not initialize Audio device"<<std::endl;
		return false;
	}

UnGuard
return true;
}	

void ExManagerSound::DisplayAviableInput (void) {
Guard (void ExManagerSound::DisplayAviableInput (void))
	*Consol<<"****************************************"<<std::endl;
	*Consol<<"*Checking for Audio                    *"<<std::endl;
	*Consol<<"****************************************"<<std::endl;
	*Consol<<"Company        : "<<alGetString (AL_VENDOR)<<std::endl;
	*Consol<<"Version        : "<<alGetString (AL_VERSION)<<std::endl;
	*Consol<<"Renderer       : "<<alGetString (AL_RENDERER)<<std::endl;
	*Consol<<"Extensions     : "<<alGetString (AL_EXTENSIONS)<<std::endl;
	if (alIsExtensionPresent ((ALubyte*) "AL_LOKI_attenuation_scale")) 
	{
		*Consol<<"Found AL_LOKI_attenuation_scale"<<std::endl;
	}
UnGuard
}

bool ExManagerSound::LoadSound (std::string file) {
Guard (bool ExManagerSound::LoadSound(std::string file))
	
UnGuard
return false;
}

void ExManagerSound::PlaySound (std::string file) {
Guard (void ExManagerSound::PlaySound (std::string file))
UnGuard
}

void ExManagerSound::StopSound (std::string file) {
Guard (void ExManagerSound::StopSound (std::string file))
UnGuard
}

int ExManagerSound::GetSound (std::string file) {
Guard (ExCSound* ExManagerSound::GetSound (std::string file))
	return -1;
UnGuard
}

bool ExManagerSound::RemoveSound (std::string file) {
Guard (bool ExManagerSound::RemoveSound (std::string file))
	return true;
UnGuard
}

void ExManagerSound::ListAllSound (void) {
Guard (void ExManagerSound::ListAllSound (void))

UnGuard
}

void ExManagerSound::Reset (void) {
Guard (void ExManagerSound::Reset (void))
UnGuard
}

