/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerTexture.cpp,v 1.28 2002/08/01 18:45:58 data Exp $
 *
 */
 
#include "ExManagerTexture.h"

ExManagerTexture::ExManagerTexture(void)
{
Guard(ExManagerTexture::ExManagerTexture(void))
	m_CouterTextures=0;
UnGuard
}


ExManagerTexture::~ExManagerTexture(void)
{
Guard(ExManagerTexture::~ExManagerTexture(void))
UnGuard
}


void  ExManagerTexture::Reset(void)
{
Guard(void  ExManagerTexture::Reset(void))
	m_VecTextures.clear();
	m_CouterTextures=0;
UnGuard
}


void  ExManagerTexture::Init(void)
{
Guard(void  ExManagerTexture::Init(void))
UnGuard
}


bool  ExManagerTexture::Init(char * FileName)
{
Guard(bool  ExManagerTexture::Init(char * FileName))
	//openf file and load object
	return true;
UnGuard
}

bool ExManagerTexture::CheckExist(const char * name)
{
Guard(ExManagerTexture::CheckExist(const char * name))
	std::string FileName(name);
	if(FileName.find(".")<FileName.length())//if extension remove them
	{
		FileName.erase(FileName.find("."),FileName.length()-FileName.find("."));
	}	
	if(m_CouterTextures>0)
	{
		for(m_ItVecTextures=m_VecTextures.begin();m_ItVecTextures!=m_VecTextures.end();m_ItVecTextures++)
		{
			
			if(strcmp(m_ItVecTextures->GetFileName(),FileName.data())==0)
			{
				return true;
			}
		}
	}
	return false;
UnGuard
}


bool ExManagerTexture::AddTexture(const char * name)
{
Guard(ExManagerTexture::AddTexture(const char * name))
	if(CheckExist(name)){return true;}
	//cheking extension type
	ExCTexture *texture;
	bool Loaded=false;
	tImage *image;
	std::string		StrPath,FileName(name);
	image= new	tImage();
	texture= new ExCTexture;	
	#ifdef UNIX_SRC
		StrPath=PREFIX "/ExNihilo/Data/Textures/";
	#else
		StrPath="../Data/Textures/";
	#endif
	//watching for file exentions type
	if(FileName.find(".bmp")==(FileName.length()-4))
	{
		Loaded=LoadBMP(image,StrPath+FileName);
		if(!Loaded)return false;
	}
	if(FileName.find(".tga")==(FileName.length()-4))
	{
		Loaded=LoadTGA(image,StrPath+FileName);
		if(!Loaded)return false;
	}
	if(FileName.find(".jpg")==(FileName.length()-4))
	{
		Loaded=LoadJPG(image,StrPath+FileName);
		if(!Loaded)return false;
	}
	// no aviable extension was found 
	if(!Loaded)
	{
		//watch if there is a extension
		if(FileName.find(".")<FileName.length())
		{
			//ther is a unknow extension
			*Consol<<"File format not supported :"<<FileName.data()<<std::endl;
		}
	}
	//there is no extension try to find correct extension 
	if(!Loaded)Loaded = LoadBMP(image,StrPath+FileName+".bmp");
	if(!Loaded)Loaded = LoadTGA(image,StrPath+FileName+".tga");
	if(!Loaded)Loaded = LoadJPG(image,StrPath+FileName+".jpg");
	if(Loaded)
	{
		texture->SetFileName(name);
		m_CouterTextures++;

		glGenTextures(1,&texture->m_Texture);
		glPixelStorei (GL_UNPACK_ALIGNMENT, 1);
        glBindTexture(GL_TEXTURE_2D,texture->m_Texture);
 		// Assume that the texture is a 24 bit RGB texture (We convert 16-bit ones to 24-bit)
		int textureType = GL_RGB;
		// If the image is 32-bit (4 channels), then we need to specify GL_RGBA for an alpha
		if(image->channels == 4)textureType = GL_RGBA;
        //glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
        glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); 
        gluBuild2DMipmaps(GL_TEXTURE_2D,4, image->sizeX, image->sizeY, textureType, GL_UNSIGNED_BYTE, image->data);
		// Build Mipmaps (builds different versions of the picture for distances - looks better)
		//gluBuild2DMipmaps(GL_TEXTURE_2D,image->channels,image->sizeX,image->sizeY, textureType, GL_UNSIGNED_BYTE, image->data);
		//Assign the mip map levels and texture info
		//glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
		glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
		m_VecTextures.push_back(*texture);
		*Consol<<"MannagerTexture:: New texture added "<<texture->GetFileName()<<" with Id:"<<texture->m_Texture<<std::endl;
		return true;
	}
	*Consol<<"MannagerTexture:: Error loading texture :"<<FileName.data()<<std::endl;
	return false;
UnGuard
}


GLuint ExManagerTexture::GetTexture(char * name)
{
Guard(ExManagerTexture::GetTexture(char * name))
	for(m_ItVecTextures=m_VecTextures.begin();m_ItVecTextures!=m_VecTextures.end();m_ItVecTextures++)
	{
		if(strcmp(m_ItVecTextures->GetFileName(),name)==0)
		{		
			return  m_ItVecTextures->GetGlTextureId();
		}	
	}
	return (GLuint) 0;
UnGuard
}

bool ExManagerTexture::SetActiveTexture(char * name)
{
Guard(ExManagerTexture::SetActiveTexture(char * name))
	std::string FileName(name);
	if(FileName.find(".")<FileName.length())//if extension remove them
	{
		FileName.erase(FileName.find("."),FileName.length()-FileName.find("."));
		memset(name,0,strlen(name));		
		sprintf(name,"%s",FileName.data());
	}
	for(m_ItVecTextures=m_VecTextures.begin();m_ItVecTextures!=m_VecTextures.end();m_ItVecTextures++)
	{
		if (m_ItVecTextures->GetFileName () != NULL && name != NULL) 
		{
			if (strcmp(m_ItVecTextures->GetFileName(),name)==0) 
			{
				m_ItVecTextures->SetActive();
				return true;
			}
		}
	}
	return false;
UnGuard
}

void ExManagerTexture::ListAllTexture(void)
{
Guard(ExManagerTexture::ListAllTexture(void))
	for(m_ItVecTextures=m_VecTextures.begin();m_ItVecTextures!=m_VecTextures.end();m_ItVecTextures++)
	{
		*Consol<<"Texture Id:"<<m_ItVecTextures->m_Texture<<" Material name:"<<m_ItVecTextures->GetFileName()<<std::endl;
	}
	*Consol<<"Number of texture in manager :"<<m_VecTextures.size()<<std::endl;
UnGuard
}

