/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExManagerWindow.cpp,v 1.16 2002/08/06 16:52:59 binny Exp $
 *
 */

#include "ExManagerWindow.h"

ExManagerWindow::ExManagerWindow(void){
Guard(ExManagerWindow::ExManagerWindow(void))
	m_ShowGrille=false;
	m_ShowNetStat=false;
	m_Antialliasing=true;
	m_Menu=false;
	m_Console=false;
	m_Interface=false;
	
	options = new ExCOptions;
	
	m_ShowFps = options->getWindowShowfps ();
	
	m_WindowSizeX = options->getWindowResolutionX ();
	m_WindowSizeY = options->getWindowResolutionY ();
	m_WindowSizeXOld = m_WindowSizeX;
	m_WindowSizeYOld = m_WindowSizeY;
	m_WindowPosX=0;
	m_WindowPosY=0;
	m_Bits = options->getWindowDepth ();
	m_Rate = options->getWindowRate ();
	m_FullScreen = options->getWindowFullscreen () ;
	m_OldMode=m_FullScreen;
	m_Cursor=GLUT_CURSOR_CROSSHAIR;
	m_Title=new char[strlen("ExNihilo Engine Version ")+20];
	sprintf(m_Title,"ExNihilo Engine Version %s",VERSION);
	m_IconTitle=new char[strlen("ExNihilo Engine Version ")+20];
	sprintf(m_IconTitle,"ExNihilo %s",VERSION);
	SetAntialliasingState(true);
	m_MotionBlurTexture=false;
	m_CouterEffect=0.0f;
UnGuard
}

ExManagerWindow::~ExManagerWindow(void)
{
Guard(ExManagerWindow::~ExManagerWindow(void))

UnGuard
}

void ExManagerWindow::Create(int SizeX,int SizeY,int PosX,int PosY,char *argv){
Guard(ExManagerWindow::Create(int SizeX,int SizeY,int PosX,int PosY,char *argv))
	m_WindowSizeX=SizeX;
	m_WindowSizeY=SizeY;
	m_WindowSizeXOld=SizeX;
	m_WindowSizeYOld=SizeY;
	m_WindowPosX=PosX;
	m_WindowPosY=PosY;
	glutInitWindowPosition(m_WindowPosX,m_WindowPosY);
	glutInitWindowSize(m_WindowSizeX,m_WindowSizeY);		
	m_WindowHandler=glutCreateWindow(m_Title);
	glutSetIconTitle(m_IconTitle);
	SetCursor(m_Cursor);
UnGuard
}

void ExManagerWindow::Create(int SizeX,int SizeY,char *argv){
Guard(ExManagerWindow::Create(int SizeX,int SizeY,char *argv))
	m_WindowSizeX=SizeX;
	m_WindowSizeY=SizeY;
	m_WindowSizeXOld=SizeX;
	m_WindowSizeYOld=SizeY;
	glutInitWindowPosition(m_WindowPosX,m_WindowPosY);
	glutInitWindowSize(m_WindowSizeX,m_WindowSizeY);		
	m_WindowHandler=glutCreateWindow(m_Title);
	glutSetIconTitle(m_IconTitle);
	SetCursor(m_Cursor);
UnGuard
}

void ExManagerWindow::Move(int Posx,int Posy){
Guard(ExManagerWindow::Move(int Posx,int Posy))
	m_WindowPosX=Posx;
	m_WindowPosY=Posy;
	glutPositionWindow(Posx,Posy);
UnGuard
}


void ExManagerWindow::SetResolution(int SizeX,int SizeY){
Guard(ExManagerWindow::SetResolution(int SizeX,int SizeY))
	m_WindowSizeXOld=m_WindowSizeX;
	m_WindowSizeYOld=m_WindowSizeY;	
	m_WindowSizeX=SizeX;
	m_WindowSizeY=SizeY;
UnGuard
}

void ExManagerWindow::SetWindowTitle(char *Title){
Guard(ExManagerWindow::SetWindowTitle(char *Title))
	m_Title = new char[strlen(Title)];
	sprintf(m_Title,"%s",Title);
	glutSetWindowTitle(m_Title);
UnGuard
}

void ExManagerWindow::SetIconTitle(char *Title){
Guard(ExManagerWindow::SetIconTitle(char *Title))
	m_IconTitle=new char[strlen(Title)];
	sprintf(m_IconTitle,"%s",Title);
	glutSetIconTitle(m_IconTitle);
UnGuard
}

void ExManagerWindow::SetCursor(int Cursor){
Guard(ExManagerWindow::SetCursor(int Cursor))
	glutSetCursor(Cursor);
UnGuard
}


void ExManagerWindow::Apply(void){
Guard(ExManagerWindow::Apply(void))
	if(options->getWindowFullscreen ())
	{
		if(m_OldMode)
		{
			glutDestroyWindow(m_WindowHandler);
		}
		char *game;
		game=new char[15];
		sprintf(game,"%dx%d:%d@%d",m_WindowSizeX,m_WindowSizeY,m_Bits,m_Rate);
		glutGameModeString(game);
#ifndef UNIX_SRC
		if (glutGameModeGet(GLUT_GAME_MODE_POSSIBLE)) {
#else
		if (glutGameModeGet(GLUT_GAME_MODE_WIDTH)) {
#endif
			m_WindowHandler=glutEnterGameMode();
			GlutCallBack();
			glutSetWindow(m_WindowHandler);

		} else {
			std::cout << "can not switch to fullscreen" << std::endl;
		}
	}else
	{
		if(m_OldMode)
		{
			glutLeaveGameMode();
			glutInitWindowPosition(m_WindowPosX,m_WindowPosY);
			glutInitWindowSize(m_WindowSizeX,m_WindowSizeY);		
			m_WindowHandler=glutCreateWindow(m_Title);
		}else
		{
			glutReshapeWindow(m_WindowSizeX,m_WindowSizeY);
		}
	}
	SetAntialliasingState(m_Antialliasing);
UnGuard
}

void ExManagerWindow::SetAntialliasingState(bool state)
{
Guard(void ExManagerWindow::SetAntialliasingState(bool state))
	m_Antialliasing=state;
	if(m_Antialliasing)
	{
		glEnable(GL_LINE_SMOOTH);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		glHint(GL_LINE_SMOOTH_HINT,GL_DONT_CARE);
	}else
	{
		glDisable(GL_LINE_SMOOTH);
		glDisable(GL_BLEND);
	}
UnGuard
}

void ExManagerWindow::ShowFps(void)
{
Guard(void ExManagerWindow::ShowFps(void))
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
		glLoadIdentity();
		gluOrtho2D(0, GetResolutionX(), 0, GetResolutionY());
		glScalef(1, -1, 1);
		glTranslatef(0, -GetResolutionY(),0);
		glMatrixMode(GL_MODELVIEW);
 		glDisable(GL_LIGHTING);
		glPushMatrix();
			glLoadIdentity();
			glColor3f(1.0,1.0,1.0);

			frame++;
			timeframe=glutGet(GLUT_ELAPSED_TIME);
			if (timeframe - timebase > 1000) 
			{
				sprintf(s,"FPS:%4.2f",frame*1000.0/(timeframe-timebase));
				timebase = timeframe;		
				frame = 0;
			}

			RenderBitmapString(30,15,(void *)GLUT_BITMAP_HELVETICA_12,"ExNihilo");
			RenderBitmapString(30,35,(void *)GLUT_BITMAP_HELVETICA_12,s);
			char TimeSinceStart[30];
			sprintf(TimeSinceStart,"Time since start:%f"
				,(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000));
			RenderBitmapString(30,55,(void *)GLUT_BITMAP_HELVETICA_12,TimeSinceStart);

		glPopMatrix();
    	glMatrixMode(GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
UnGuard
}

void ExManagerWindow::MotionBlur(void)
{
Guard(void ExManagerWindow::MotionBlur(void))
	if(!m_MotionBlurTexture)
	{
		// Create a pointer to store the blank image data
		unsigned int *pTexture = NULL;											

		// Allocate and init memory for the image array and point to it from pTexture
		pTexture = new unsigned int [512 * 512 * 3];
		memset(pTexture, 0, 512 * 512 * 3 * sizeof(unsigned int));	

		// Register the texture with OpenGL and bind it to the texture ID
		glGenTextures(1, &TextureMotionBlur);								
		glBindTexture(GL_TEXTURE_2D, TextureMotionBlur);					
		
		// Create the texture and store it on the video card
		glTexImage2D(GL_TEXTURE_2D, 0, 3, 512, 512, 0, GL_RGB, GL_UNSIGNED_INT, pTexture);						
		
		// Set the texture quality
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);

		// Since we stored the texture space with OpenGL, we can delete the image data
		delete [] pTexture;							
		m_MotionBlurTexture=true;
	}

	// Push on a new stack so that we do not interfere with the current matrix
	glPushMatrix();

		// Turn off depth testing so that we can blend over the screen
		glDisable(GL_DEPTH_TEST);			

		// Set our blend method and enable blending
		//glBlendFunc(GL_SRC_ALPHA,GL_ONE);	
		//glEnable(GL_BLEND);					

		
		// Decrease the alpha value of the blend by %10 so it will fade nicely
		glColor4f(1, 1, 1, 0.9f);

		// Switch to 2D mode (Ortho mode)
		EnterOrthoMode(0, 0, m_WindowSizeX, m_WindowSizeY);

		// Display a 2D quad with our blended texture
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D,TextureMotionBlur);
		glBegin(GL_QUADS);


			// Display the top left point of the 2D image
			glTexCoord2f(0.0f, 1.0f);	glVertex2f(0, 0);

			// Display the bottom left point of the 2D image
			//glTexCoord2f(0.0f, 0.0f);	glVertex2f(0, m_WindowSizeY);
			glTexCoord2f(0.0f, 0.0f);	glVertex2f(0, 80);

			// Display the bottom right point of the 2D image
			//glTexCoord2f(1.0f, 0.0f);	glVertex2f(m_WindowSizeX, m_WindowSizeY);
			glTexCoord2f(1.0f, 0.0f);	glVertex2f(80, 80);

			// Display the top right point of the 2D image
			//glTexCoord2f(1.0f, 1.0f);	glVertex2f(m_WindowSizeX, 0);
			glTexCoord2f(1.0f, 1.0f);	glVertex2f(80, 0);

		// Stop drawing 
		glEnd();
		glDisable(GL_TEXTURE_2D);
		// Let's set our mode back to perspective 3D mode.
		LeaveOrthoMode();

		// Turn depth testing back on and texturing off.  If you do NOT do these 2 lines of 
		// code it produces a cool flash effect that might come in handy somewhere down the road.
		glEnable(GL_DEPTH_TEST);						
		glDisable(GL_BLEND);							
		
	// Go back to our original matrix
	glPopMatrix();	
UnGuard
}

void ExManagerWindow::CapturForMotionBlur(void)
{
Guard(void ExManagerWindow::CapturForMotionBlur(void))
	glBindTexture(GL_TEXTURE_2D,TextureMotionBlur);
	glCopyTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 0, 0, 512, 512, 0);
UnGuard
}


void ExManagerWindow::ShowNetStat(void)
{
Guard(void ExManagerWindow::ShowNetStat(void))
UnGuard
}

void ExManagerWindow::EnterOrthoMode(int left, int top, int right, int bottom)
{
	glMatrixMode(GL_PROJECTION);						
	glPushMatrix();									
	glLoadIdentity();								
	glOrtho( left, right, bottom, top, 0, 1 );	
	glMatrixMode(GL_MODELVIEW);								
	glLoadIdentity();										
}

void ExManagerWindow::LeaveOrthoMode(void)	
{
	glMatrixMode( GL_PROJECTION );							
	glPopMatrix();											
	glMatrixMode( GL_MODELVIEW );							
}

void ExManagerWindow::Specialeffect(void)
{
	switch(m_effect)
	{
	case FADE_TO_WHITE:		
		glColor4ub(255,255,255, (uchar)m_CouterEffect);
		EnterOrthoMode(0, 0, m_WindowSizeX, m_WindowSizeY);
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		LeaveOrthoMode();
		m_CouterEffect++;
				
		if(m_CouterEffect>255)
		{
			m_CouterEffect=0;
			m_effect=0;
		}
		break;
	case WITHE_TO_FADE:
		glColor4ub(255,255,255, m_CouterEffect);
		EnterOrthoMode(0, 0, m_WindowSizeX, m_WindowSizeY);
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		LeaveOrthoMode();
		m_CouterEffect--;
				
		if(m_CouterEffect<1)
		{
			m_CouterEffect=255;
			m_effect=0;
		}
		break;
	case FADE_TO_BLACK:
		glColor4ub(0,0,0, m_CouterEffect);
		EnterOrthoMode(0, 0, m_WindowSizeX, m_WindowSizeY);
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		LeaveOrthoMode();
		m_CouterEffect++;
				
		if(m_CouterEffect>255)
		{
			m_CouterEffect=0;
			m_effect=0;
		}
		break;
	case BLACK_TO_FADE:
		glColor4ub(0,0,0, m_CouterEffect);
		EnterOrthoMode(0, 0, m_WindowSizeX, m_WindowSizeY);
		
		glEnable(GL_BLEND);	
		glDisable(GL_DEPTH_TEST);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
		
		glBegin(GL_QUADS);
			glVertex2f(0, 0);
			glVertex2f(0, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, m_WindowSizeY);
			glVertex2f(m_WindowSizeX, 0);
		glEnd();
			
		glDisable(GL_BLEND);		
		glEnable(GL_DEPTH_TEST);

		LeaveOrthoMode();
		m_CouterEffect--;
				
		if(m_CouterEffect<1)
		{
			m_CouterEffect=255;
			m_effect=0;
		}
		break;
	}
}
void ExManagerWindow::SetSpecialEffect(int effect)
{
	m_effect=effect;
	switch(m_effect)
	{
	case FADE_TO_WHITE:
		m_CouterEffect=0;
		break;
	case WITHE_TO_FADE:
		m_CouterEffect=256;
		break;
	case FADE_TO_BLACK:
		m_CouterEffect=0;
		break;
	case BLACK_TO_FADE:
		m_CouterEffect=256;
		break;
	}
}
