/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCMesh.cpp,v 1.5 2002/07/01 09:23:36 data Exp $
 *
 */

#include "ExCMesh.h"

ExCMesh::ExCMesh(void)
{
	m_AB=0;
	m_BC=0;
	m_CA=0;
	m_Smoothing=0;
	m_Material = new char[strlen("NONE")];
	sprintf(m_Material,"NONE");
	m_MeshNumber=0;
}

ExCMesh::ExCMesh(ExCVertex  a,ExCVertex  b,ExCVertex  c)
{
	SetVertex(a,b,c);
}

ExCMesh::~ExCMesh(void)
{

}

void ExCMesh::SetMaterial(const char *Material)
{
Guard(void ExCMesh::SetMaterial(char *Material));
	m_Material = new char[strlen(Material)];
	sprintf(m_Material,Material);
UnGuard
}

void ExCMesh::SetVertex(ExCVertex  a,ExCVertex  b,ExCVertex  c)
{
Guard(void ExCMesh::SetVertex(ExCVertex  a,ExCVertex  b,ExCVertex  c))
	A=a;
	B=b;
	C=c;
UnGuard
}

void ExCMesh::Affich(void)
{
	std::cout<<"Mesh "<<m_MeshNumber<<":   AB :"<<m_AB<<" BC:"<<m_BC<<" CA:"<<m_CA<<std::endl;
	std::cout<<"Material:"<<m_Material<<std::endl;
	std::cout<<"Smoothing:"<<m_Smoothing<<std::endl;
}
