/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCVec3D.cpp,v 1.6 2002/07/08 23:14:46 data Exp $
 *
 */

#include "ExCVec3D.h"

// Construction/Destruction

ExCVec3D::ExCVec3D()
{
	m_Vector[0]=0;m_Vector[1]=0;m_Vector[2]=0;
}

ExCVec3D::ExCVec3D(float x,float y,float z)
{
	m_Vector[0]=x;m_Vector[1]=y;m_Vector[2]=z;
}

ExCVec3D::~ExCVec3D()
{

}

// Methode

float ExCVec3D::GetVectorLenght(void)
{
	return sqrt((m_Vector[0]*m_Vector[0])+(m_Vector[1]*m_Vector[1])+(m_Vector[2]*m_Vector[2]));
}
ExCVec3D ExCVec3D::GetVecNormale(void)
{
	ExCVec3D VecNorm;
	VecNorm=*this;
	VecNorm=*this/this->GetVectorLenght();
	return VecNorm;
}
void ExCVec3D::SetValue(float x,float y,float z)
{
	m_Vector[0]=x;
	m_Vector[1]=y;
	m_Vector[2]=z;
}

void ExCVec3D::Draw(void)
{
	ExCVec3D vx,vy,vz;
	ExCVec3D source;

	source.SetValue(0.0f,0.0f,0.0f);

	

	vx.m_Vector[0]=this->m_Vector[0]+1.0f;
	vy.m_Vector[1]=this->m_Vector[1]+1.0f;
	vz.m_Vector[2]=this->m_Vector[2]+1.0f;


	glBegin(GL_TRIANGLES);
		glColor3ub(255,255,255);
		glVertex3f(0.0f,0.0f,0.0f);
		glVertex3f(1.0f,1.0f,1.0f);
		glVertex3f(-1.0f,-1.0f,-1.0f);
	glEnd();

	glBegin(GL_LINE);
		glColor3ub(255,0,0);
			glVertex3fv(source.m_Vector);
			glVertex3fv(vx.m_Vector);
		glColor3ub(0,255,0);
			glVertex3fv(source.m_Vector);
			glVertex3fv(vy.m_Vector);
		glColor3ub(0,0,255);
			glVertex3fv(source.m_Vector);
			glVertex3fv(vz.m_Vector);
	glEnd();
}

// Operator surcharge
ExCVec3D& ExCVec3D::operator =(const ExCVec3D& Vec)
{
	m_Vector[0]=Vec.m_Vector[0];
	m_Vector[1]=Vec.m_Vector[1];
	m_Vector[2]=Vec.m_Vector[2];
	return *this;
}
bool  ExCVec3D::operator==(const ExCVec3D& Vec)
{
	if(m_Vector[0]==Vec.m_Vector[0]||m_Vector[1]==Vec.m_Vector[1]||m_Vector[2]==Vec.m_Vector[2]) return true;
	else return false;
}

ExCVec3D  ExCVec3D::operator+(const ExCVec3D& Vec)
{
	ExCVec3D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]+Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]+Vec.m_Vector[1];
	RetVec.m_Vector[2]=m_Vector[2]+Vec.m_Vector[2];
	return RetVec;
}

ExCVec3D  ExCVec3D::operator-(const ExCVec3D& Vec)
{
	ExCVec3D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]-Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]-Vec.m_Vector[1];
	RetVec.m_Vector[2]=m_Vector[2]-Vec.m_Vector[2];
	return RetVec;
}
ExCVec3D  ExCVec3D::operator*(const ExCVec3D& Vec)
{
	ExCVec3D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]*Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]*Vec.m_Vector[1];
	RetVec.m_Vector[2]=m_Vector[2]*Vec.m_Vector[2];
	return RetVec;
}
ExCVec3D  ExCVec3D::operator*(float scalar)
{
	ExCVec3D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]*scalar;
	RetVec.m_Vector[1]=m_Vector[1]*scalar;
	RetVec.m_Vector[2]=m_Vector[2]*scalar;
	return RetVec;
}
ExCVec3D  ExCVec3D::operator/(const ExCVec3D& Vec)
{
	ExCVec3D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]/Vec.m_Vector[0];
	RetVec.m_Vector[1]=m_Vector[1]/Vec.m_Vector[1];
	RetVec.m_Vector[2]=m_Vector[2]/Vec.m_Vector[2];
	return RetVec;
}
ExCVec3D  ExCVec3D::operator/(float scalar)
{
	ExCVec3D RetVec;
	RetVec.m_Vector[0]=m_Vector[0]/scalar;
	RetVec.m_Vector[1]=m_Vector[1]/scalar;
	RetVec.m_Vector[2]=m_Vector[2]/scalar;
	return RetVec;
}

// Friends
std::ostream& operator<<(std::ostream& s,const ExCVec3D &vec)
{
	s<<"X:"<<(float)vec.m_Vector[0]<<" Y:"<<(float)vec.m_Vector[1]<<" Z:"<<(float)vec.m_Vector[2];
	return s;
}

