/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCVertex.cpp,v 1.4 2002/06/16 00:51:08 binny Exp $
 *
 */

#include "ExCVertex.h"

ExCVertex::ExCVertex(void)
{
	m_dA=0.0f;
	m_dB=0.0f;
	m_dG=0.0f;
	m_dR=0.0f;
	m_dU=0.0f;
	m_dV=0.0f;
	m_dX=0.0f;
	m_dY=0.0f;
	m_dZ=0.0f;
}

ExCVertex::ExCVertex(double x,double y,double z)
{
	SetA(0.0f);
	SetB(0.0f);
	SetG(0.0f);
	SetR(0.0f);
	SetU(0.0f);
	SetV(0.0f);
	SetX(x);
	SetY(y);
	SetZ(z);
}

ExCVertex::ExCVertex(double x,double y,double z,double u,double v)
{
	m_dA=0.0f;
	m_dB=0.0f;
	m_dG=0.0f;
	m_dR=0.0f;
	m_dU=u;
	m_dV=v;
	m_dX=x;
	m_dY=y;
	m_dZ=z;
}

ExCVertex::ExCVertex(double x,double y,double z,double r,double g,double b,double a)
{
	m_dA=a;
	m_dB=b;
	m_dG=g;
	m_dR=r;
	m_dU=0.0f;
	m_dV=0.0f;
	m_dX=x;
	m_dY=y;
	m_dZ=z;
}

ExCVertex::ExCVertex(double x,double y,double z,double u,double v,double r,double g,double b,double a)
{
	m_dA=a;
	m_dB=b;
	m_dG=g;
	m_dR=r;
	m_dU=u;
	m_dV=v;
	m_dX=x;
	m_dY=y;
	m_dZ=z;
}

/*ExCVertex::ExCVertex(ExCVertex& copy)
{
	m_dA=copy.GetA();
	m_dB=copy.GetB();
	m_dG=copy.GetG();
	m_dR=copy.GetR();
	m_dU=copy.GetU();
	m_dV=copy.GetV();
	m_dX=copy.GetX();
	m_dY=copy.GetY();
	m_dZ=copy.GetZ();
}*/

ExCVertex::~ExCVertex(void)
{
}
/*
ExCVertex& ExCVertex::operator =(const ExCVertex&  vertex)
{
	m_dA=vertex->GetA();
	m_dB=vertex->GetB();
	m_dG=vertex->GetG();
	m_dR=vertex->GetR();
	m_dU=vertex->GetU();
	m_dV=vertex->GetV();
	m_dX=vertex->GetX();
	m_dY=vertex->GetY();
	m_dZ=vertex->GetZ();
	return *this;
}

ExCVertex ExCVertex::operator +(ExCVertex a)
{
	SetA(a.GetA());
	SetB(a.GetB());
	SetG(a.GetG());
	SetR(a.GetR());
	SetU(a.GetU());
	SetV(a.GetV());
	SetX(a.GetX()+GetX());
	SetY(a.GetY()+GetY());
	SetZ(a.GetZ()+GetZ());
	return this;
}

ExCVertex ExCVertex::operator -(ExCVertex a)
{
	SetA(a.GetA());
	SetB(a.GetB());
	SetG(a.GetG());
	SetR(a.GetR());
	SetU(a.GetU());
	SetV(a.GetV());
	SetX(GetX()-a.GetX());
	SetY(GetY()-a.GetY());
	SetZ(GetZ()-a.GetZ());
	return this;
}

bool ExCVertex::operator ==(const ExCVertex a)
{
	if(a.GetA()==GetB()&&
   		a.GetB()==GetB()&&
		a.GetG()==GetG()&&
		a.GetR()==GetR()&&
		a.GetU()==GetU()&&
		a.GetV()==GetV()&&
		a.GetX()==GetX()&&
		a.GetY()==GetY()&&
		a.GetZ()==GetZ())
	{
		return true;
	}else 
	{
		return false;
	}
}*/
