/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExQuaternion.cpp,v 1.4 2002/06/16 00:51:09 binny Exp $
 *
 */

#include "ExQuaternion.h"

ExQuaternion::ExQuaternion()
{
	SetQuaternion(1,0,0,0);
}

ExQuaternion::ExQuaternion(float w,float x,float y,float z)
{
	SetQuaternion(w,x,y,z);
}

ExQuaternion::~ExQuaternion()
{

}

//////////////////////////////////////////////////////////////////////
// Methode
//////////////////////////////////////////////////////////////////////
void ExQuaternion::SetQuaternion(float w,float x,float y,float z)
{
	qw=w;
	qx=x;
	qy=y;
	qz=z;
}

void ExQuaternion::Conjugate(void)
{

}

void ExQuaternion::LoadIdentity(void)
{
	qx=-qx;
	qy=-qy;
	qz=-qz;
}
float ExQuaternion::GetMagnitude(void)
{
	return(sqrt(qw*qw+qx*qx+qy*qy+qz*qz));
	
}
void ExQuaternion::Normalize(void)
{
	float factor=GetMagnitude();
	float scaleby(1.0/sqrt(factor));
	qw=qw*scaleby;
	qx=qx*scaleby;
	qy=qy*scaleby;
	qz=qz*scaleby;
}

void ExQuaternion::SetEuler(float yaw,float pitch,float roll)
{
	float cosY = cosf(yaw/2.0f);
	float sinY = sinf(yaw/2.0f);
	float cosP = cosf(pitch/2.0f);
	float sinP = sinf(pitch/2.0f);
	float cosR = cosf(roll/2.0f);
	float sinR = sinf(roll/2.0f);

	qw=cosR*sinP*cosY+sinR*cosP*sinY;
	qx=cosR*cosP*sinY-sinR*sinP*cosY;
	qy=sinR*cosP*cosY-cosR*sinP*sinY;
	qz=cosR*cosP*cosY+sinR*sinP*sinY;

}
//////////////////////////////////////////////////////////////////////
// Operator
//////////////////////////////////////////////////////////////////////
ExQuaternion ExQuaternion::operator* (const ExQuaternion &Q)
{
	ExQuaternion result;
	result.qw=(Q.qw*result.qw)-(Q.qx*result.qx)-(Q.qy*result.qy)-(Q.qz*result.qz);
	result.qx=(Q.qw*result.qx)-(Q.qx*result.qw)-(Q.qy*result.qz)-(Q.qz*result.qw);
	result.qy=(Q.qw*result.qy)-(Q.qx*result.qz)-(Q.qy*result.qw)-(Q.qz*result.qx);
	result.qz=(Q.qw*result.qz)-(Q.qx*result.qy)-(Q.qy*result.qx)-(Q.qz*result.qw);
	return result;
}
//////////////////////////////////////////////////////////////////////
// friends methode
//////////////////////////////////////////////////////////////////////

std::ostream& operator<<(std::ostream& s,const ExQuaternion &q)
{
Guard(friend std::ostream& operator<<(std::ostream& s,const ExQuaternion &q))
	s<<"W:"<<q.qw<<"X:"<<q.qx<<"Y:"<<q.qy<<"Z:"<<q.qz<<std::endl;
	return s;
UnGuard
}
