/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCCamera.cpp,v 1.7 2002/07/10 11:09:46 data Exp $
 *
 */

#include "ExCCamera.h"


ExCCamera::ExCCamera(void)
{
Guard(ExCCamera::ExCCamera(void))
	m_AngleX=0;
	m_AngleY=0;
	m_AngleZ=0;
	m_speed=0;
	m_ZoomDefault=40;
	m_Zoom=m_ZoomDefault;
	m_ZoomMin=1;
	m_ZoomMax=100;
	m_ClipFar=2000;
	m_ClipNear=1;

	m_vPosition.SetValue(0.0,0.0,1.0);
	m_vView.SetValue(0.0,1.0,0.5);
	m_vUpVector.SetValue(0.0,0.0,1.0);
UnGuard
}

ExCCamera::~ExCCamera(void)
{
Guard(ExCCamera::~ExCCamera(void))
UnGuard
}

void ExCCamera::Draw(void)
{
Guard(ExCCamera::Draw(void))
//cout<<"Draw "<<m_ObjectName<<" ID:"<<m_ObjectId<<endl;

	if(m_AngleX<0)m_AngleX=359;
	if(m_AngleX>359)m_AngleX=0;
	if(m_AngleY<0)m_AngleY=359;
	if(m_AngleY>359)m_AngleY=0;
	if(m_AngleZ<0)m_AngleZ=359;
	if(m_AngleZ>359)m_AngleZ=0;

	ExCMatrix4x4 Matrice,Matr;
	//ExCVec3D VecX,VecY,VecZ,VecDir;

	ExQuaternion Quat;
	
	
	Quat.SetEuler(m_AngleX,m_AngleY,m_AngleZ);
	Matr=GetMatrixFromQuaternion(Quat);
	
	//Matr=GetMatrixFromEuler(m_AngleX,m_AngleY,m_AngleZ);


	//glLoadMatrixf(Matr.m_Matrix);	
	
	/*glRotatef(m_AngleX,1.0,0.0,0.0);
	glRotatef(m_AngleY,0.0,1.0,0.0);
	glLoadIdentity();
	glLoadMatrixf(Matr.m_Matrix);
	cout<<Matr;
	cout<<Quat;*/
	
	VecX.m_Vector[0]=Matr.m_Matrix[0];
	VecX.m_Vector[1]=Matr.m_Matrix[1];
	VecX.m_Vector[2]=Matr.m_Matrix[2];
	VecY.m_Vector[0]=Matr.m_Matrix[4];
	VecY.m_Vector[1]=Matr.m_Matrix[5];
	VecY.m_Vector[2]=Matr.m_Matrix[6];
	VecZ.m_Vector[0]=Matr.m_Matrix[8];
	VecZ.m_Vector[1]=Matr.m_Matrix[9];
	VecZ.m_Vector[2]=Matr.m_Matrix[10];

	VecDir.m_Vector[0]=VecX.GetVectorLenght();
	VecDir.m_Vector[1]=VecY.GetVectorLenght();
	VecDir.m_Vector[2]=VecZ.GetVectorLenght();

	//cout<<VecDir<<endl;
	//glGetFloatv(GL_MODELVIEW_MATRIX,
	
	//glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ()); 
	if(m_speed!=0)
	{
		for(int i=0;i<m_speed;i++)
		{
			GoToView(true);
		}
	}else
	{
	m_Target.SetX((Cos[(int)m_AngleY]+m_Position.GetX()));
	m_Target.SetZ((Sin[(int)m_AngleY]+m_Position.GetZ()));
	m_Target.SetY((Sin[(int)m_AngleX]+m_Position.GetY()));
	}
	//glRotatef(m_AngleZ,0.0,0.0,1.0);
	gluLookAt(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ()
			,m_Target.GetX(),m_Target.GetY(),m_Target.GetZ()
			,0.0,1.0,0.0);
	
UnGuard
}

void ExCCamera::GoToView(bool state)
{
Guard(void ExCCamera::GoToView(void))
	//bool GoodY=true; // not used
	m_Position=m_Target;
	m_Target.SetX((Cos[(int)m_AngleY]+m_Position.GetX()));
	m_Target.SetZ((Sin[(int)m_AngleY]+m_Position.GetZ()));
	m_Target.SetY((Sin[(int)m_AngleX]+m_Position.GetY()));

UnGuard
}

void ExCCamera::ResetZoom(void)
{
Guard(void ExCCamera::ResetZoom(void))
	m_Zoom=m_ZoomDefault;
UnGuard
}

void ExCCamera::SetZoomDefault(float zoom)
{
Guard(void ExCCamera:: SetZoomDefault(float zoom))
	if(zoom<m_ZoomMax&&zoom>m_ZoomMin)
		m_ZoomDefault=zoom;
UnGuard
}

void ExCCamera::ZoomIn(void)
{
Guard(void ExCCamera::ZoomIn(void))
	m_Zoom--;
	if(m_Zoom<=m_ZoomMin)m_Zoom=m_ZoomMin+1;
UnGuard
}

void ExCCamera::ZoomOut(void)
{
Guard(void ExCCamera::ZoomOut(void))
	m_Zoom++;
	if(m_Zoom>=m_ZoomMax)m_Zoom=m_ZoomMax-1;
UnGuard
}

void ExCCamera::ZoomIn(float zoom)
{
Guard(void ExCCamera::ZoomIn(float zoom))
	m_Zoom=m_Zoom-zoom;
	if(m_Zoom<=m_ZoomMin)m_Zoom=m_ZoomMin+1;
UnGuard
}

void ExCCamera::ZoomOut(float zoom)
{
Guard(void ExCCamera::ZoomOut(float zoom))
	m_Zoom=m_Zoom+m_ZoomMax;
	if(m_Zoom>=m_ZoomMax)m_Zoom=m_ZoomMax-1;
UnGuard
}

void ExCCamera::SetZoom(float zoom)
{
Guard(void ExCCamera::SetZoom(float zoom))
UnGuard
}

void ExCCamera::SetZoomMax(float zoom)
{
Guard(void ExCCamera::SetZoomMax(float zoom))
UnGuard
}

void ExCCamera::SetZoomMin(float zoom)
{
Guard(void ExCCamera::SetZoomMin(float zoom))
UnGuard
}

void ExCCamera::SetClipFar(float clip)
{
	Guard(void ExCCamera::SetClipFar(float clip))
	m_ClipFar=clip;
	if(m_ClipFar<m_ClipNear)m_ClipFar=m_ClipNear+1;
UnGuard
}

void ExCCamera::SetClipNear(float clip)
{
	Guard(void ExCCamera::SetClipNear(float clip))
	m_ClipNear=clip;
	if(m_ClipNear>m_ClipFar)m_ClipNear=m_ClipFar-1;
UnGuard
}

void ExCCamera::RotateView(float X, float Y, float Z)
{
Guard(void ExCCamera::RotateView(float X, float Y, float Z))
	ExCVec3D vVector;							// Vector for the position/view.

	// Get our view vVector (The direction we are facing)
	vVector.m_Vector[0] = m_vView.m_Vector[0] - m_vPosition.m_Vector[0];		// This gets the direction of the X	
	vVector.m_Vector[1] = m_vView.m_Vector[1] - m_vPosition.m_Vector[1];		// This gets the direction of the Y
	vVector.m_Vector[2]= m_vView.m_Vector[2] - m_vPosition.m_Vector[2];		// This gets the direction of the Z

	// If we pass in a negative X Y or Z, it will rotate the opposite way,
	// so we only need one function for a left and right , up or down rotation.
	// I suppose we could have one move function too, but I decided not too.

	if(X) {
		m_vView.m_Vector[2] = (float)(m_vPosition.m_Vector[2] + sin(X)*vVector.m_Vector[1] + cos(X)*vVector.m_Vector[2]);
		m_vView.m_Vector[1] = (float)(m_vPosition.m_Vector[1] + cos(X)*vVector.m_Vector[1] - sin(X)*vVector.m_Vector[2]);
	}
	if(Y) {
		m_vView.m_Vector[2] = (float)(m_vPosition.m_Vector[2] + sin(Y)*vVector.m_Vector[0] + cos(Y)*vVector.m_Vector[2]);
		m_vView.m_Vector[0] = (float)(m_vPosition.m_Vector[0] + cos(Y)*vVector.m_Vector[0] - sin(Y)*vVector.m_Vector[2]);
	}
	if(Z) {
		m_vView.m_Vector[0] = (float)(m_vPosition.m_Vector[0] + sin(Z)*vVector.m_Vector[1] + cos(Z)*vVector.m_Vector[0]);		
		m_vView.m_Vector[1] = (float)(m_vPosition.m_Vector[1] + cos(Z)*vVector.m_Vector[1] - sin(Z)*vVector.m_Vector[0]);
	}
UnGuard
}

void ExCCamera::StrafeCamera(float speed)
{
Guard(void ExCCamera::StrafeCamera(float speed))

UnGuard
}

void ExCCamera::MoveCamera(float speed)
{
Guard(void ExCCamera::MoveCamera(float speed))
	ExCVec3D vVector;					// Init a vVector for our view

	// Get our view vVector (The direciton we are facing)
	vVector.m_Vector[0] = m_vView.m_Vector[0] - m_vPosition.m_Vector[0];		// This gets the direction of the X	
	vVector.m_Vector[1] = m_vView.m_Vector[1] - m_vPosition.m_Vector[1];		// This gets the direction of the Y
	vVector.m_Vector[2] = m_vView.m_Vector[2] - m_vPosition.m_Vector[2];		// This gets the direction of the Z

	m_vPosition.m_Vector[0] += vVector.m_Vector[0] * speed;		// Add our acceleration to our position's X
	m_vPosition.m_Vector[2] += vVector.m_Vector[2] * speed;		// Add our acceleration to our position's Z
	m_vView.m_Vector[0] += vVector.m_Vector[0] * speed;			// Add our acceleration to our view's X
	m_vView.m_Vector[2] += vVector.m_Vector[2] * speed;			// Add our acceleration to our view's Z
UnGuard
}

