/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCComposed.cpp,v 1.12 2002/07/08 23:14:47 data Exp $
 *
 */

#include "ExCComposed.h"

ExCComposed::ExCComposed(void)
{
	m_RenderMode=RENDER_LINES;
}

ExCComposed::~ExCComposed(void)
{
}

void ExCComposed::MakeList(void)
{
Guard(void ExCComposed::MakeList(void))
	//glDeleteLists(m_GlListId,1);	//delete old list
	m_GlListId=glGenLists(1);	//Ask for a new free list
	glNewList(m_GlListId,GL_COMPILE);
	for(m_ItVecEntite=m_VecEntite.begin();m_ItVecEntite!=m_VecEntite.end();m_ItVecEntite++)
	{
		m_ItVecEntite->DrawWithoutList();
		//m_ItVecEntite->m_BoxPvs.Draw();
	}
	glEndList();
UnGuard
}

void ExCComposed::SetRenderMode(int RenderMode)
{
Guard(void ExCComposed::SetRenderMode(int RenderMode))
	for(m_ItVecEntite=m_VecEntite.begin();m_ItVecEntite!=m_VecEntite.end();m_ItVecEntite++)
	{
		m_ItVecEntite->SetRenderMode(RenderMode);
		glDeleteLists(m_ItVecEntite->GetGlListId(),1);
	}
	MakeList();
UnGuard
}

void ExCComposed::BuildPvsBox(void)
{
	for(m_ItVecEntite=m_VecEntite.begin();m_ItVecEntite!=m_VecEntite.end();m_ItVecEntite++)
	{
		m_ItVecEntite->BuildPvsBox();
	}  
}

void ExCComposed::SetManagerTexture(ExManagerTexture * Texture)
{
	ManagerTexture=Texture;
	for(m_ItVecEntite=m_VecEntite.begin();m_ItVecEntite!=m_VecEntite.end();m_ItVecEntite++)
	{
		m_ItVecEntite->SetManagerTexture(Texture);
	}  
}

void ExCComposed::Draw(void)
{
	double tmplife;
	ExCVec3D ForceResult;
	ExCMatrix4x4 Matr;
		ExQuaternion quat;

	
	

	

	tmplife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000)-m_StartingLife;
	if(tmplife-m_Life>=m_RefreshTime)
	{
		
		if(m_Acceleration!=0.0f)
		{
			if(m_Velocity.m_Vector[0]!=0.0f)
			{
				m_Velocity.m_Vector[0]=m_Velocity.m_Vector[0]+((double)m_Acceleration*((double)(tmplife-m_Life)/1000));
			}
			if(m_Velocity.m_Vector[1]!=0.0f)
			{
				m_Velocity.m_Vector[1]=m_Velocity.m_Vector[1]+((double)m_Acceleration*((double)(tmplife-m_Life)/1000));
			}
			if(m_Velocity.m_Vector[2]!=0.0f)
			{
				m_Velocity.m_Vector[2]=m_Velocity.m_Vector[2]+((double)m_Acceleration*((double)(tmplife-m_Life)/1000));
			}
		}
		//m_Position=m_Position+m_Velocity-m_Gravity;
		quat=GetQuaternionFromEuler(m_AngleX,m_AngleY,m_AngleZ);
		//Matr=GetMatrixFromQuaternion(quat);
		Matr=GetMatrixFromEuler(m_AngleX,m_AngleY,m_AngleZ);

		ForceResult.m_Vector[0]=	(Matr.m_Matrix[0]*m_Velocity.m_Vector[0])+
								(Matr.m_Matrix[4]*m_Velocity.m_Vector[1])+
								(Matr.m_Matrix[8]*m_Velocity.m_Vector[2])+
								(Matr.m_Matrix[12]*0.0f);


		ForceResult.m_Vector[1]=	(Matr.m_Matrix[1]*m_Velocity.m_Vector[0])+
								(Matr.m_Matrix[5]*m_Velocity.m_Vector[1])+
								(Matr.m_Matrix[9]*m_Velocity.m_Vector[2])+
								(Matr.m_Matrix[13]*0.0f);

		ForceResult.m_Vector[2]=	(Matr.m_Matrix[2]*m_Velocity.m_Vector[0])+
								(Matr.m_Matrix[6]*m_Velocity.m_Vector[1])+
								(Matr.m_Matrix[10]*m_Velocity.m_Vector[2])+
								(Matr.m_Matrix[14]*0.0f);

		
		//std::cout<<quat<<std::endl;
		//std::cout<<Matr<<std::endl;
		//std::cout<<m_Velocity<<std::endl;
		m_Position=m_Position+m_Velocity-m_Gravity+ForceResult;
		//m_Position=m_Position-m_Gravity+ForceResult;

		m_Life=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000)-m_StartingLife;
	}
	
	
	glPushMatrix();
		glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());
		glRotatef(m_AngleX,1.0f,0.0f,0.0f);
		glRotatef(m_AngleY,0.0f,1.0f,0.0f);
		glRotatef(-90,0.0f,0.0f,1.0f);
		glRotatef(m_AngleZ,0.0f,0.0f,1.0f);
		
		glCallList(m_GlListId);
		if(m_ShowInfo && m_CurrentObject)ShowInfo();
	glPopMatrix();
	
}

bool ExCComposed::LoadAsc(char *FileName)
{
Guard(void LoadAsc(char *FileName))
	bool			endfile=false;
	int				FileSize;
	int				RetVal;
	int				TmpFilePosition;
	int				i,j,k;
 	FILE			*MyFile;
 	std::cout<<"Load File :"<<FileName;
	MyFile=fopen (FileName,"r");
	if(!MyFile)
	{
		return false;
	}
 	fseek(MyFile,0,SEEK_END);
	FileSize=ftell(MyFile);
	std::cout<<" Size:"<<FileSize<<std::endl;
	//Start of file
	fseek(MyFile,0,SEEK_SET);
	do
	{
		bool			Textured=false;
		ExCEntite		EntiteBuff;
		const char		*Name;
		char			ch;
		std::string		SName;
		std::string		SNumber;
		ExCVertex		VertexBuff;
		//------------------
		//Read object name
		//------------------
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!=34);
		TmpFilePosition=ftell(MyFile);//remember where name start
		i=0;
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);i++;
		}while(ch!=34);
		fseek(MyFile,TmpFilePosition,SEEK_SET);
		for(j=0;j<i-1;j++)
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SName=SName+ch;
		}
		Name = SName.data();
		EntiteBuff.SetName(Name);
		std::cout<<"Name :"<<EntiteBuff.GetName()<<std::endl;
		//-----------------------------
		//Read number of vertex en face
		//-----------------------------
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!=':');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip the space
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch!=' ');
		EntiteBuff.SetNumberVertex(atol(SNumber.data()));		
		
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!=':');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip the space
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		EntiteBuff.SetNumberMesh(atol(SNumber.data()));		
		std::cout<<"Number of Vertex :"<<EntiteBuff.GetNumberVertex()<<" Number of Mesh :"<<EntiteBuff.GetNumberMesh()<<std::endl;
		//-----------------------------
		//Read vertex 
		//-----------------------------	
		for(j=0;j<EntiteBuff.GetNumberVertex();j++)
		{
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='X');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			try
			{
				VertexBuff.SetX(atof(SNumber.data()));
			}catch(...)
			{
				VertexBuff.SetV(0.0f);
				std::cout<<"Error on vertex V:"<<j<<std::endl;	
			}
 			//-------------------------------------------------------------
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='Y');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			try
			{
				VertexBuff.SetY(atof(SNumber.data()));
			}catch(...)
			{
				VertexBuff.SetV(0.0f);
				std::cout<<"Error on vertex V:"<<j<<std::endl;	
			}
 			//-------------------------------------------------------------
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='Z');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			try
			{
				VertexBuff.SetZ(atof(SNumber.data()));
			}catch(...)
			{
				VertexBuff.SetV(0.0f);
				std::cout<<"Error on vertex V:"<<j<<std::endl;	
			}
			//--------------------------------------------------------------
			//VertexBuff.Affich();std::cout<<std::endl;
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			if(ch==' ')//if object has U and V value
			{
				Textured=true;
				//-------------------------------------------------------------
				SNumber.erase(SNumber.begin(),SNumber.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
				}while(ch!='U');
				RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					SNumber=SNumber+ch;
				}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
						ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
				VertexBuff.SetU(atof(SNumber.data()));
				//-------------------------------------------------------------
				SNumber.erase(SNumber.begin(),SNumber.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
				}while(ch!='V');
				RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					SNumber=SNumber+ch;
				}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
						ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
				VertexBuff.SetV(atof(SNumber.data()));
				//-------------------------------------------------------------
			}
			
			EntiteBuff.AddVertex(VertexBuff);

		}
		//-----------------------------
		//Read face 
		//-----------------------------	
		for(j=0;j<EntiteBuff.GetNumberMesh();j++)
		{
			ExCMesh			MeshBuff;
			MeshBuff.m_MeshNumber=j;
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='A');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			MeshBuff.A=EntiteBuff.GetVertex(atoi(SNumber.data()));
			
			//-------------------------------------------------------------
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='B');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			MeshBuff.B=EntiteBuff.GetVertex(atoi(SNumber.data()));
			//-------------------------------------------------------------
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='C');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			MeshBuff.C=EntiteBuff.GetVertex(atoi(SNumber.data()));
			//------------------------------------------------------------
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='B');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			MeshBuff.m_AB=atoi(SNumber.data());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='C');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			MeshBuff.m_BC=atoi(SNumber.data());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='A');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			MeshBuff.m_CA=atoi(SNumber.data());
			if(Textured)
			{
				//-----------------------------
				//Read material 
				//-----------------------------
				std::string Material;
     			do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
				}while(ch!=34);
				TmpFilePosition=ftell(MyFile);//remember where name start
				i=0;
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);i++;
				}while(ch!=34);
				fseek(MyFile,TmpFilePosition,SEEK_SET);
				for(k=0;k<i-1;k++)
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					Material=Material+ch;
				}
				MeshBuff.SetMaterial(Material.data());
				ManagerTexture->AddTexture(Material.data());
			}
			//-----------------------------
			//Read Smoothing 
			//-----------------------------
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!=':');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip espace
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			MeshBuff.m_Smoothing=atoi(SNumber.data());
			
			EntiteBuff.AddMesh(MeshBuff);
		}
		//---------------------------
		m_VecEntite.push_back(EntiteBuff);	   
		//-----------------
		TmpFilePosition=ftell(MyFile);//where i am?
		std::cout<<TmpFilePosition<<std::endl;
		if(TmpFilePosition+100>FileSize)
		{			
			endfile=true;
		}else
		{
			endfile=false;
		}
	}while(!endfile);
   

   fclose(MyFile);
   BuildPvsBox();
   return true;
UnGuard
}
