/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCEntite.cpp,v 1.12 2002/07/07 00:35:10 data Exp $
 *
 */

#include "ExCEntite.h"

ExCEntite::ExCEntite(void)
{
Guard(ExCEntite::ExCEntite(void))
	ExCObject::ExCObject();
	m_RenderMode=RENDER_LINES;
	MakeList();
UnGuard
}

ExCEntite::~ExCEntite(void)
{
Guard(ExCEntite::~ExCEntite(void))
UnGuard
}

void ExCEntite::Draw(void)
{
Guard(void ExCEntite::Draw(void))
//std::cout<<"Draw "<<m_ObjectName<<" ID:"<<m_ObjectId<<"Opengl List ID:"<<m_GlListId<<std::endl;
	
	double tmplife;
	tmplife=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000)-m_StartingLife;
	if(tmplife-m_Life>=m_RefreshTime)
	{
		m_Position=m_Position+m_Velocity-m_Gravity;
		if(m_Acceleration!=0.0f)
		{
			if(m_Velocity.m_Vector[0]!=0.0f)
			{
				m_Velocity.m_Vector[0]=m_Velocity.m_Vector[0]+((double)m_Acceleration*((double)(tmplife-m_Life)/1000));
			}
			if(m_Velocity.m_Vector[1]!=0.0f)
			{
				m_Velocity.m_Vector[1]=m_Velocity.m_Vector[1]+((double)m_Acceleration*((double)(tmplife-m_Life)/1000));
			}
			if(m_Velocity.m_Vector[2]!=0.0f)
			{
				m_Velocity.m_Vector[2]=m_Velocity.m_Vector[2]+((double)m_Acceleration*((double)(tmplife-m_Life)/1000));
			}
		}
		m_Life=(double)((double)glutGet(GLUT_ELAPSED_TIME)/1000)-m_StartingLife;
	}
	glPushMatrix();
	glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());
	glCallList(m_GlListId);
	//m_BoxPvs.Draw();
	glPopMatrix();
UnGuard
}

void ExCEntite::BuildPvsBox(void)
{
Guard(void ExCEntite::BuildPvsBox(void))
	//Serach for max and min value
	double MaxX,MaxY,MaxZ,MinX,MinY,MinZ;
	m_ItVecVertex=m_VecVertex.begin();
	MaxX=m_ItVecVertex->GetX();
	MinX=m_ItVecVertex->GetX();
	MaxY=m_ItVecVertex->GetY();
	MinY=m_ItVecVertex->GetY();
	MaxZ=m_ItVecVertex->GetZ();
	MinZ=m_ItVecVertex->GetZ();
	m_ItVecVertex++;
	for(;m_ItVecVertex!=m_VecVertex.end();++m_ItVecVertex)
	{
		if(m_ItVecVertex->GetX()<MinX)
		{
			MinX=m_ItVecVertex->GetX();
		}else
		if(m_ItVecVertex->GetX()>MaxX)
		{
			MaxX=m_ItVecVertex->GetX();			
		}
		
		if(m_ItVecVertex->GetY()<MinY)
		{
			MinY=m_ItVecVertex->GetY();
		}else
		if(m_ItVecVertex->GetY()>MaxY)
		{
			MaxY=m_ItVecVertex->GetY();			
		}
		
		if(m_ItVecVertex->GetZ()<MinZ)
		{
			MinZ=m_ItVecVertex->GetZ();
		}else
		if(m_ItVecVertex->GetZ()>MaxZ)
		{
			MaxZ=m_ItVecVertex->GetZ();			
		}
	
	}
	m_BoxPvs.m_Vertex[0].SetX(MaxX);
	m_BoxPvs.m_Vertex[0].SetY(MaxY);
	m_BoxPvs.m_Vertex[0].SetZ(MinZ);
	m_BoxPvs.m_Vertex[1].SetX(MaxX);
	m_BoxPvs.m_Vertex[1].SetY(MaxY);
	m_BoxPvs.m_Vertex[1].SetZ(MaxZ);
	m_BoxPvs.m_Vertex[2].SetX(MinX);
	m_BoxPvs.m_Vertex[2].SetY(MaxY);
	m_BoxPvs.m_Vertex[2].SetZ(MaxZ);
	m_BoxPvs.m_Vertex[3].SetX(MinX);
	m_BoxPvs.m_Vertex[3].SetY(MaxY);
	m_BoxPvs.m_Vertex[3].SetZ(MinZ);
	m_BoxPvs.m_Vertex[4].SetX(MaxX);
	m_BoxPvs.m_Vertex[4].SetY(MinY);
	m_BoxPvs.m_Vertex[4].SetZ(MinZ);
	m_BoxPvs.m_Vertex[5].SetX(MaxX);
	m_BoxPvs.m_Vertex[5].SetY(MinY);
	m_BoxPvs.m_Vertex[5].SetZ(MaxZ);
	m_BoxPvs.m_Vertex[6].SetX(MinX);
	m_BoxPvs.m_Vertex[6].SetY(MinY);
	m_BoxPvs.m_Vertex[6].SetZ(MaxZ);
	m_BoxPvs.m_Vertex[7].SetX(MinX);
	m_BoxPvs.m_Vertex[7].SetY(MinY);
	m_BoxPvs.m_Vertex[7].SetZ(MinZ);

UnGuard
}


void ExCEntite::SetRenderMode(int RenderMode)
{
Guard(void ExCEntite::SetRenderMode(int RenderMode))
	m_RenderMode=RenderMode;
	MakeList();
UnGuard
}

void ExCEntite::MakeList(void)
{
Guard(void ExCEntite::MakeList(void))

	glDeleteLists(m_GlListId,1);	//delete old list
	m_GlListId=glGenLists(1);	//Ask for a new free list
	//std::cout<<"New list Id:"<<m_GlListId<<std::endl;
	glNewList(m_GlListId,GL_COMPILE);
	DrawWithoutList();
	glEndList();
UnGuard
}

void ExCEntite:: DrawWithoutList(void)
{
Guard(void ExCEntite:: DrawWithoutList(void))
 
	switch(m_RenderMode)
	{
	case RENDER_TEXTURES_LIGHT:
		break;
    case RENDER_TEXTURES:
		glColor3f(1.0f, 1.0f, 1.0f);
    	glEnable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		
		
	    for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
		{
			#ifdef DEBUG
				if(!ManagerTexture->SetActiveTexture(m_ItVecMesh->GetMaterial()))
				{
					std::cout<<"can not find texture for mesh :"<<std::endl;
					m_ItVecMesh->Affich();
				}
			#endif
			glBegin(GL_TRIANGLES);
			glTexCoord2f(m_ItVecMesh->A.GetU(), m_ItVecMesh->A.GetV());
			glVertex3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
			glTexCoord2f(m_ItVecMesh->B.GetU(), m_ItVecMesh->B.GetV());
			glVertex3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
			glTexCoord2f(m_ItVecMesh->C.GetU(), m_ItVecMesh->C.GetV());
			glVertex3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());
			glEnd();
		}
	
		glDisable(GL_TEXTURE_2D);
 		break;
	case RENDER_TRIANGLES_LIGHT:
			glPushMatrix();
			glColor3f(1.0f, 1.0f, 1.0f);
			glBegin(GL_TRIANGLES);
			for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
			{
				glNormal3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
				glVertex3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
				glNormal3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
				glVertex3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
				glNormal3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());
				glVertex3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());				
			}
			glEnd();
			glPopMatrix();
		break;
	case RENDER_TRIANGLES:
			glDisable(GL_LIGHTING);
			glPushMatrix();
			glColor3f(1.0f, 1.0f, 1.0f);
			glBegin(GL_TRIANGLES);
				for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
				{
					glVertex3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
					glVertex3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
					glVertex3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());
				}
			glEnd();
			glPopMatrix();
			glEnable(GL_LIGHTING);
			break;
	case RENDER_POINTS:
		glDisable(GL_LIGHTING);
		glBegin(GL_POINTS);
			glColor3f(1.0f, 1.0f, 1.0f);
			for(m_ItVecVertex=m_VecVertex.begin();m_ItVecVertex!=m_VecVertex.end();++m_ItVecVertex)
			{
				glVertex3f(m_ItVecVertex->GetX(),m_ItVecVertex->GetY(),m_ItVecVertex->GetZ());
			}
		glEnd();
		glEnable(GL_LIGHTING);
		break;
	case RENDER_LINES:
			glDisable(GL_LIGHTING);
			glPushMatrix();
				glColor3f(1.0f, 1.0f, 1.0f);
				for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
				{
					glBegin(GL_LINE_LOOP);
					glVertex3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
					glVertex3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
					glVertex3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());
					glEnd();
				}
			glPopMatrix();
			glEnable(GL_LIGHTING);
		break;
	case RENDER_NO:
		break;
   	}
UnGuard
}


void ExCEntite::AddVertex(ExCVertex Vertex)
{
Guard(void ExCEntite::AddVertex(ExCVertex Vertex))
	m_VecVertex.push_back(Vertex);
UnGuard
}

void ExCEntite::AddMesh(ExCMesh Mesh)
{
Guard(void ExCEntite::AddMesh(ExCMesh Mesh))
	m_VecMesh.push_back(Mesh);
UnGuard
}

ExCVertex ExCEntite::GetVertex(int pos)
{
Guard(ExCVertex ExCEntite::GetVertex(int pos))
	return m_VecVertex.at(pos);
UnGuard
}

bool ExCEntite::LoadAsc(char *FileName)
{
Guard(void LoadAscEntite(char *FileName))
	bool			Textured;
	int				FileSize;
	int				RetVal;
	int				TmpFilePosition;
	int				i,j,k;
	const char		*Name;
	char			ch;
	std::string		SName;
	std::string		SNumber;
	FILE			*MyFile;
	ExCVertex		VertexBuff;

	
	char *buffer;
	buffer= new char[15+strlen(FileName)];
	sprintf(buffer,"Load File :%s",FileName);
    //WriteToConsol(buffer);
	
	Textured=false;
	MyFile=fopen (FileName,"r");
	if(!MyFile)
	{
//		WriteToConsol("File not found");
	
		return false;
	}
 	fseek(MyFile,0,SEEK_END);
	FileSize=ftell(MyFile);
	buffer= new char[15];
	sprintf(buffer,"Size:%d",FileSize);
    //WriteToConsol(buffer);
	//Start of file
	fseek(MyFile,0,SEEK_SET);
	//------------------
	//Read object name
	//------------------
	do
	{
		RetVal=fread(&ch,sizeof(char),1,MyFile);
	}while(ch!=34);
	TmpFilePosition=ftell(MyFile);//remember where name start
	i=0;
	do
	{
		RetVal=fread(&ch,sizeof(char),1,MyFile);i++;
	}while(ch!=34);
	fseek(MyFile,TmpFilePosition,SEEK_SET);
	for(j=0;j<i-1;j++)
	{
		RetVal=fread(&ch,sizeof(char),1,MyFile);
		SName=SName+ch;
	}
	Name = SName.data();
	SetName(Name);
	//-----------------------------
	//Read number of vertex en face
	//-----------------------------
	do
	{
		RetVal=fread(&ch,sizeof(char),1,MyFile);
	}while(ch!=':');
	RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip the space
    do
	{
		RetVal=fread(&ch,sizeof(char),1,MyFile);
		SNumber=SNumber+ch;
	}while(ch!=' ');
	SetNumberVertex(atol(SNumber.data()));		
	
	SNumber.erase(SNumber.begin(),SNumber.end());
	do
	{
		RetVal=fread(&ch,sizeof(char),1,MyFile);
	}while(ch!=':');
	RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip the space
    do
	{
		RetVal=fread(&ch,sizeof(char),1,MyFile);
		SNumber=SNumber+ch;
	}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
	SetNumberMesh(atol(SNumber.data()));		
	//std::cout<<"Number of Vertex :"<<m_NumberVertex<<" Number of Mesh :"<<m_NumberMesh<<std::endl;
	//-----------------------------
	//Read vertex 
	//-----------------------------	
	for(j=0;j<m_NumberVertex;j++)
	{
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='X');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
        try
		{
			VertexBuff.SetX(atof(SNumber.data()));
		}catch(...)
		{
			VertexBuff.SetV(0.0f);
			std::cout<<"Error on vertex V:"<<j<<std::endl;	
		}
 		//-------------------------------------------------------------
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='Y');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		try
		{
			VertexBuff.SetY(atof(SNumber.data()));
		}catch(...)
		{
			VertexBuff.SetV(0.0f);
			std::cout<<"Error on vertex V:"<<j<<std::endl;	
		}
 		//-------------------------------------------------------------
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='Z');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
        try
		{
			VertexBuff.SetZ(atof(SNumber.data()));
		}catch(...)
		{
			VertexBuff.SetV(0.0f);
			std::cout<<"Error on vertex V:"<<j<<std::endl;	
		}
		//--------------------------------------------------------------
		//VertexBuff.Affich();std::cout<<std::endl;
		RetVal=fread(&ch,sizeof(char),1,MyFile);
		if(ch==' ')//if object has U and V value
		{
			Textured=true;
			//-------------------------------------------------------------
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='U');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			VertexBuff.SetU(atof(SNumber.data()));
			//-------------------------------------------------------------
			SNumber.erase(SNumber.begin(),SNumber.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!='V');
			RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				SNumber=SNumber+ch;
			}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
					ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
			VertexBuff.SetV(atof(SNumber.data()));
			//-------------------------------------------------------------
		}
		m_VecVertex.push_back(VertexBuff);
	}
	//-----------------------------
	//Read face 
	//-----------------------------	
	for(j=0;j<m_NumberMesh;j++)
	{
		ExCMesh			MeshBuff;
		MeshBuff.m_MeshNumber=j;
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='A');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		MeshBuff.A=m_VecVertex.at(atoi(SNumber.data()));
		
		//-------------------------------------------------------------
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='B');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		MeshBuff.B=m_VecVertex.at(atoi(SNumber.data()));
		//-------------------------------------------------------------
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='C');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		MeshBuff.C=m_VecVertex.at(atoi(SNumber.data()));
		//------------------------------------------------------------
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='B');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		MeshBuff.m_AB=atoi(SNumber.data());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='C');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		MeshBuff.m_BC=atoi(SNumber.data());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='A');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip :
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
		MeshBuff.m_CA=atoi(SNumber.data());
		if(Textured)
		{
			//-----------------------------
			//Read material 
			//-----------------------------
			std::string Material;
     		do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
			}while(ch!=34);
			TmpFilePosition=ftell(MyFile);//remember where name start
			i=0;
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);i++;
			}while(ch!=34);
			fseek(MyFile,TmpFilePosition,SEEK_SET);
			for(k=0;k<i-1;k++)
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				Material=Material+ch;
			}
			MeshBuff.SetMaterial(Material.data());
		}
		//-----------------------------
		//Read Smoothing 
		//-----------------------------
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!=':');
		RetVal=fread(&ch,sizeof(char),1,MyFile);//one more to skip espace
		SNumber.erase(SNumber.begin(),SNumber.end());
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			SNumber=SNumber+ch;
		}while(ch=='0'||ch=='1'||ch=='2'||ch=='3'||ch=='4'||ch=='5'||
				ch=='6'||ch=='7'||ch=='8'||ch=='9'||ch=='.'||ch=='-');
	   MeshBuff.m_Smoothing=atoi(SNumber.data());
	   m_VecMesh.push_back(MeshBuff);
	}
	fclose(MyFile);
	BuildPvsBox();
	return true;
UnGuard
}
