/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCInterface.cpp,v 1.3 2002/08/01 19:37:50 binny Exp $
 *
 */

#include "ExCInterface.h"

ExCInterface::ExCInterface(void)
{
Guard(ExCInterface::ExCInterface(void))
	m_ShowRegion=true;
	m_State=true;
UnGuard
}

ExCInterface::~ExCInterface(void)
{
Guard(ExCInterface::~ExCInterface(void))
UnGuard
}


void ExCInterface::LoadTextureInterface(void)
{
Guard(void ExCInterface::LoadTextureInterface(void))
	ManagerTexture->AddTexture(m_Texture);
	ManagerTexture->AddTexture(m_TextureMask);
UnGuard
}

	
bool ExCInterface::LoadInterface(const char * FileName)
{
Guard(bool ExCInterface::LoadInterface(const char * FileName))
	//-----------------------------------
	//structure of interface file .
	//-----------------------------------
	//#interface#				type of file
	//800#600#					basic resolution 
	//bmp#						image interface
	//mask#						mask inetrface
	//int#int#string#int#int	1 int action
	//							2 int command
	//							3 argument
	//							4 int posx mouse
	//							5 int posy mouse
	//...
	//end of interface file#

	
  	char			ch;
	int				RetVal;
	int				FileSize;
	FILE			*MyFile;
	bool			endfile=false;
	//int				tmp=0; // not used
	std::string		StBuffer;
	char			buffer[255];
	ActionCommand	ActCom;
	
#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Interface/%s",FileName);
#else
	sprintf(buffer,"../Data/Interface/%s",FileName);
#endif
	m_InterfaceName=new char[strlen(FileName)];
	sprintf(m_InterfaceName,"%s",FileName);
    
	MyFile=fopen (buffer,"r");
	if(!MyFile)
	{
		*Consol<<"INTERFACE >> File not found:"<<buffer<<std::endl;
		return false;
	}else
	{
		
		*Consol<<"INTERFACE >>  Loading interface File "<<FileName<<std::endl;
			
 		fseek(MyFile,0,SEEK_END);
		FileSize=ftell(MyFile);
		//Start of file
		fseek(MyFile,0,SEEK_SET);
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='#');
		//reading file type;
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			StBuffer=StBuffer+ch;	
		}while(ch!='#');
		if(strcmp(StBuffer.data(),"interface#")==0)
		{
			//read default resolution
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			try
			{
				m_DefaultResolutionX=atoi(StBuffer.data());
			}catch(...)
			{
				m_DefaultResolutionX=0;
			}
			
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			try
			{
				m_DefaultResolutionY=atoi(StBuffer.data());
			}catch(...)
			{
				m_DefaultResolutionY=0;	
			}
            //read image
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			
			m_Texture= new char[strlen(StBuffer.data())+18];
			sprintf(m_Texture,"%s",StBuffer.data());
			//read mask
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			
			m_TextureMask= new char[strlen(StBuffer.data())+18];
			sprintf(m_TextureMask,"%s",StBuffer.data());

			do
			{
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				if(StBuffer.find("end of interface file")!=(unsigned)-1)
				{
					endfile=true;
				}else
				{
					//	action
					try
					{
						ActCom.m_Action=atoi(StBuffer.data());
					}catch(...)
					{
						ActCom.m_Action=NOTHING;	
					}
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					// command
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					try
					{
						ActCom.m_Command=atoi(StBuffer.data());
					}catch(...)
					{
						ActCom.m_Command=NOTHING;	
					}
					
					// param
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					memset(ActCom.m_Param,0,255);
					sprintf(ActCom.m_Param," %s",StBuffer.data());
					// mousex
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					try
					{
						ActCom.m_MouseXup=atoi(StBuffer.data());
					}catch(...)
					{
						ActCom.m_MouseXup=-1;	
					}
					
					// mousey
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					try
					{
						ActCom.m_MouseYup=atoi(StBuffer.data());
					}catch(...)
					{
						ActCom.m_MouseYup=-1;	
					}
					// mousexd
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					try
					{
						ActCom.m_MouseXdown=atoi(StBuffer.data());
					}catch(...)
					{
						ActCom.m_MouseXdown=-1;	
					}
					
					// mouseyd
					StBuffer.erase(StBuffer.begin(),StBuffer.end());
					do
					{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
					}while(ch!='#');
					StBuffer.erase(StBuffer.end()-1,StBuffer.end());
					try
					{
						ActCom.m_MouseYdown=atoi(StBuffer.data());
					}catch(...)
					{
						ActCom.m_MouseYdown=-1;	
					}
				m_VecActionCommand.push_back(ActCom);	
				}
			}while(!endfile);
			fclose(MyFile);
       		LoadTextureInterface();
			return true;
		}else
		{
			*Consol<<FileName<<" is not a valide interface file"<<std::endl;
			return false;
		}
	}
UnGuard
}

void ExCInterface::DrawInterface(void)
{
Guard(void ExCInterface::DrawInterface(void))
    glPushMatrix();
	ManagerWindow->EnterOrthoMode(0,0,ManagerWindow->GetResolutionX(),ManagerWindow->GetResolutionY());
	
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glColor4f(1, 1, 1, 1);
	glDisable(GL_DEPTH_TEST);
	glBlendFunc(GL_DST_COLOR,GL_ZERO);
	glEnable(GL_BLEND);											
	
	ManagerTexture->SetActiveTexture(m_TextureMask);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 1.0f);	glVertex2f(0, 0);
		glTexCoord2f(0.0f, 0.0f);	glVertex2f(0, ManagerWindow->GetResolutionY());
		glTexCoord2f(1.0f, 0.0f);	glVertex2f(ManagerWindow->GetResolutionX(), ManagerWindow->GetResolutionY());
		glTexCoord2f(1.0f, 1.0f);	glVertex2f(ManagerWindow->GetResolutionX(), 0);
	glEnd();	

	glBlendFunc(GL_ONE,GL_ONE);
	ManagerTexture->SetActiveTexture(m_Texture);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 1.0f);	glVertex2f(0, 0);
		glTexCoord2f(0.0f, 0.0f);	glVertex2f(0, ManagerWindow->GetResolutionY());
		glTexCoord2f(1.0f, 0.0f);	glVertex2f(ManagerWindow->GetResolutionX(), ManagerWindow->GetResolutionY());
		glTexCoord2f(1.0f, 1.0f);	glVertex2f(ManagerWindow->GetResolutionX(), 0);
    glEnd();	
	
	glDisable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_DEPTH_TEST);
	
	
	if(m_ShowRegion)
	{
		int i=0;
		for(m_ItVecActionCommand=m_VecActionCommand.begin();m_ItVecActionCommand!=m_VecActionCommand.end();m_ItVecActionCommand++,i++)
		{
			
			double Xup,Yup,Xdo,Ydo,cofx=1,cofy=1;
			/*Xup=((double)m_ItVecActionCommand->m_MouseXup/m_DefaultResolutionX)*ManagerWindow->GetResolutionX();
			Yup=((double)m_ItVecActionCommand->m_MouseYup/m_DefaultResolutionY)*ManagerWindow->GetResolutionY();
			Xdo=((double)m_ItVecActionCommand->m_MouseXdown/m_DefaultResolutionX)*ManagerWindow->GetResolutionX();
			Ydo=((double)m_ItVecActionCommand->m_MouseYdown/m_DefaultResolutionY)*ManagerWindow->GetResolutionY();
			cout<<"Xup :"<<Xup<<endl;
			cout<<"Yup :"<<Yup<<endl;
			cout<<"Xdo :"<<Xdo<<endl;
			cout<<"Ydo :"<<Ydo<<endl;*/
			
			
			//cout<<"Current resolution X:"<<ManagerWindow->GetResolutionX()<<endl;
			//cout<<"Current resolution Y:"<<ManagerWindow->GetResolutionY()<<endl;
			//cout<<"Default X:"<<m_DefaultResolutionX<<endl;
			//cout<<"Default Y:"<<m_DefaultResolutionY<<endl;
			if(cofx==0)cofx=1;
			if(cofy==0)cofy=1;
			cofx=(ManagerWindow->GetResolutionX()/m_DefaultResolutionX);		
			cofy=(ManagerWindow->GetResolutionY()/m_DefaultResolutionY);
			//cout<<"cofx :"<<cofx<<endl;
			//cout<<"cofy :"<<cofy<<endl;
			

			
			
			Xup=(m_ItVecActionCommand->m_MouseXup)*cofx;
			Yup=(m_ItVecActionCommand->m_MouseYup)*cofy;
			Xdo=(m_ItVecActionCommand->m_MouseXdown)*cofx;
			Ydo=(m_ItVecActionCommand->m_MouseYdown)*cofy;
			
			if(i%1==0){glColor3f((float)i/10,1.0f-((float)i/10),1.0f);}
			if(i%2==0){glColor3f(1.0f,1.0f-((float)i/10),(float)1/10);}
			if(i%3==0){glColor3f(1.0f-((float)i/10),1.0f,(float)1/10);}
			glBegin(GL_LINE_LOOP);
				glVertex2f(Xdo,Ydo);
				glVertex2f(Xdo,Yup);
				glVertex2f(Xup,Yup);
				glVertex2f(Xup,Ydo);
			glEnd();
		}
	}
	glEnable(GL_LIGHTING);
	ManagerWindow->LeaveOrthoMode();
	glPopMatrix();
UnGuard
}

SAction ExCInterface::InputCommand(int command,int mousex,int mousey)
{
Guard(SAction ExCInterface::InputCommand(int command,int mousex,int mousey))
	int CntAct=0;
	SAction RetAct;
	
	for(m_ItVecActionCommand=m_VecActionCommand.begin();m_ItVecActionCommand!=m_VecActionCommand.end();m_ItVecActionCommand++)
	{
		if(m_ItVecActionCommand->m_Command==command)
		{
			if(m_ItVecActionCommand->m_MouseXup<0)
			{
				if(CntAct>0)
				{
					SAction	*RecursifActA;
					SAction	*RecursifActB;
					RecursifActA=&RetAct;
					for(int i=0;i<CntAct;i++)
					{
						if(RecursifActA->m_NextAction==NULL)
						{
							RecursifActA->m_NextAction=new SAction;
							RecursifActB=RecursifActA->m_NextAction;
							RecursifActB->m_Action=m_ItVecActionCommand->m_Action;
							RecursifActB->SetParam(m_ItVecActionCommand->m_Param);
						}
						RecursifActA=RecursifActA->m_NextAction;
					}
					CntAct++;
				}else
				{
					RetAct.m_Action=m_ItVecActionCommand->m_Action;
					RetAct.SetParam(m_ItVecActionCommand->m_Param);
					CntAct++;
				}
			}else
			{
				double Xup,Yup,Xdo,Ydo,Mx,My;
				Xup=((double)m_ItVecActionCommand->m_MouseXup/ManagerWindow->GetResolutionX());
				Yup=((double)m_ItVecActionCommand->m_MouseYup/ManagerWindow->GetResolutionY());
				Xdo=((double)m_ItVecActionCommand->m_MouseXdown/ManagerWindow->GetResolutionX());
				Ydo=((double)m_ItVecActionCommand->m_MouseYdown/ManagerWindow->GetResolutionY());
				Mx=((double)mousex/ManagerWindow->GetResolutionX());
				My=((double)mousey/ManagerWindow->GetResolutionY());

				/*cout<<"Resolution "<<ManagerWindow->GetResolutionX()<<" "<<ManagerWindow->GetResolutionY()<<endl;
				cout<<"Xup :"<<Xup<<endl;
				cout<<"Yup :"<<Yup<<endl;
				cout<<"Xdo :"<<Xdo<<endl;
				cout<<"Ydo :"<<Ydo<<endl;
				cout<<"Mx  :"<<Mx<<endl;
				cout<<"My  :"<<My<<endl;
				*/
				
				if((Xup>Mx)&&(Xdo<Mx)&&(Ydo<My)&&(Yup>My))
				{
					std::cout<<"clik dedans"<<std::endl;
					if(CntAct>0)
					{
						SAction	*RecursifActA;
						SAction	*RecursifActB;
						RecursifActA=&RetAct;
						for(int i=0;i<CntAct;i++)
						{
							if(RecursifActA->m_NextAction==NULL)
							{
								RecursifActA->m_NextAction=new SAction;
								RecursifActB=RecursifActA->m_NextAction;
								RecursifActB->m_Action=m_ItVecActionCommand->m_Action;
								RecursifActB->SetParam(m_ItVecActionCommand->m_Param);
							}
							RecursifActA=RecursifActA->m_NextAction;
						}
						CntAct++;
					}else
					{
						RetAct.m_Action=m_ItVecActionCommand->m_Action;
						RetAct.SetParam(m_ItVecActionCommand->m_Param);
						CntAct++;
					}
				}else
				{
					std::cout<<"click hors coordone"<<std::endl;
				}
			}
		}
	}
	if(CntAct==0)
	{
		RetAct.m_Action=NOTHING;
		RetAct.SetParam("NULL");
	}

	return RetAct;
UnGuard
}
