/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCMap.cpp,v 1.16 2002/08/01 18:45:58 data Exp $
 *
 */

#include "ExCMap.h"

ExCMap::ExCMap(void)
{
	m_ShowSkybox=true;
	m_ShowMesh=true;
	m_OctreeState=false;
	m_ShowOctreeSubdivision=false;
#ifdef UNIX_SRC
	// This is very awfull but it segfault without it
	m_VecMesh.reserve (1000);
	m_VecVertex.reserve (1000);
#endif
}

ExCMap::~ExCMap(void)
{
}

void ExCMap::BuildSkyBox(void)
{
Guard(void ExMap::BuildSkyBox(void))
		
		glDeleteLists(m_GlSkyBoxListId,1);	//delete old list
		m_GlSkyBoxListId=glGenLists(1);	//Ask for a new free list
		glNewList(m_GlSkyBoxListId,GL_COMPILE);

		glEnable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		ManagerTexture->SetActiveTexture(m_STextureBoxNameFront);
		glBegin(GL_QUADS);
			// Front Face
			glColor4f(1, 1, 1, 1);
			glTexCoord2f(1.0f, 1.0f); glVertex3f(-500.0f,  500.0f,  500.0f);
			glTexCoord2f(0.0f, 1.0f); glVertex3f( 500.0f,  500.0f,  500.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f( 500.0f, -500.0f,  500.0f);
			glTexCoord2f(1.0f, 0.0f); glVertex3f(-500.0f, -500.0f,  500.0f);
		glEnd();
		ManagerTexture->SetActiveTexture(m_STextureBoxNameBack);
		glBegin(GL_QUADS);
			// Back Face
			glTexCoord2f(1.0f, 0.0f); glVertex3f( 500.0f, -500.0f, -500.0f);
			glTexCoord2f(1.0f, 1.0f); glVertex3f( 500.0f,  500.0f, -500.0f);
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-500.0f,  500.0f, -500.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-500.0f, -500.0f, -500.0f);
		glEnd();
		ManagerTexture->SetActiveTexture(m_STextureBoxNameTop);
		glBegin(GL_QUADS);
			// Top Face
			glTexCoord2f(0.0f, 1.0f); glVertex3f( 500.0f,  500.0f, -500.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f( 500.0f,  500.0f,  500.0f);
			glTexCoord2f(1.0f, 0.0f); glVertex3f(-500.0f,  500.0f,  500.0f);
			glTexCoord2f(1.0f, 1.0f); glVertex3f(-500.0f,  500.0f, -500.0f);
		glEnd();
		ManagerTexture->SetActiveTexture(m_STextureBoxNameBottom);
		glBegin(GL_QUADS);
			// Bottom Face
            glTexCoord2f(1.0f, 1.0f); glVertex3f(-500.0f, -500.0f,  500.0f);
			glTexCoord2f(0.0f, 1.0f); glVertex3f( 500.0f, -500.0f,  500.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f( 500.0f, -500.0f, -500.0f);
			glTexCoord2f(1.0f, 0.0f); glVertex3f(-500.0f, -500.0f, -500.0f);
		glEnd();
		ManagerTexture->SetActiveTexture(m_STextureBoxNameRight);
		glBegin(GL_QUADS);
			// Right face
			glTexCoord2f(1.0f, 0.0f); glVertex3f( 500.0f, -500.0f,  500.0f);
			glTexCoord2f(1.0f, 1.0f); glVertex3f( 500.0f,  500.0f,  500.0f);
			glTexCoord2f(0.0f, 1.0f); glVertex3f( 500.0f,  500.0f, -500.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f( 500.0f, -500.0f, -500.0f);
		glEnd();
		ManagerTexture->SetActiveTexture(m_STextureBoxNameLeft);
		glBegin(GL_QUADS);
		// Left Face
			glTexCoord2f(1.0f, 1.0f); glVertex3f(-500.0f,  500.0f, -500.0f);
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-500.0f,  500.0f,  500.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-500.0f, -500.0f,  500.0f);
			glTexCoord2f(1.0f, 0.0f); glVertex3f(-500.0f, -500.0f, -500.0f);

		glEnd();
		glDisable(GL_TEXTURE_2D);
		glEnable(GL_LIGHTING);

		glEndList();
UnGuard
}

void ExCMap::DrawAllMesh(void)
{
Guard(void ExMap::DrawAllMesh(void))
	glCallList(m_GlListId);
UnGuard
}

void ExCMap::DrawMeshInFrustrum(void)
{
Guard(void ExMap::DrawMeshInFrustrum(void))
	//DrawAllMesh();
	//m_Octree.Draw();
	Frustrum.CalculateFrustum();
	glColor3f(1.0f, 1.0f, 1.0f);
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	int i=0;
	int pointinfrustrum=0;

	for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
	{
		ManagerTexture->SetActiveTexture(m_ItVecMesh->GetMaterial());
		if(Frustrum.PointInFrustum(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ()))
		{
			pointinfrustrum++;
		}
		if(Frustrum.PointInFrustum(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ()))
		{
			pointinfrustrum++;
		}
		if(Frustrum.PointInFrustum(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ()))
		{
			pointinfrustrum++;
		}
		
		if(pointinfrustrum>1)
		{
			glBegin(GL_TRIANGLES);
				glTexCoord2f(m_ItVecMesh->A.GetU(), m_ItVecMesh->A.GetV());
				glVertex3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
				glTexCoord2f(m_ItVecMesh->B.GetU(), m_ItVecMesh->B.GetV());
				glVertex3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
				glTexCoord2f(m_ItVecMesh->C.GetU(), m_ItVecMesh->C.GetV());
				glVertex3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());
			glEnd();
		}
		i++;
		pointinfrustrum=0;
	}	
	glEnable(GL_LIGHTING);
	glDisable(GL_TEXTURE_2D);
UnGuard
}

void ExCMap::Draw(void)
{
Guard(void ExMap::Draw(void))
	if(m_ShowSkybox)glCallList(m_GlSkyBoxListId);
	glPushMatrix();
	glRotatef(-90,1.0f,0.0f,0.0f);
	if(m_ShowMesh)
	{						   
		if(m_OctreeState)
		{
			DrawMeshInFrustrum();	
		}else
		{
			DrawAllMesh();
		}
	}
	glPopMatrix();

UnGuard
}

void ExCMap::BuilList(void)
{
Guard(void ExMap::BuilList(void))
	m_GlListId=glGenLists(1);
	glNewList(m_GlListId,GL_COMPILE);
		glColor3f(1.0f, 1.0f, 1.0f);
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		int i=0;
		
		for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
		{
			ManagerTexture->SetActiveTexture(m_ItVecMesh->GetMaterial());
			glBegin(GL_TRIANGLES);
			glTexCoord2f(m_ItVecMesh->A.GetU(), m_ItVecMesh->A.GetV());
			glVertex3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
			glTexCoord2f(m_ItVecMesh->B.GetU(), m_ItVecMesh->B.GetV());
			glVertex3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
			glTexCoord2f(m_ItVecMesh->C.GetU(), m_ItVecMesh->C.GetV());
			glVertex3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());
			glEnd();
			i++;
		}
		
		glEnable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
	glEndList();
UnGuard
}


void ExCMap::BuildOctree(void)
{
Guard(void ExMap::BuildOctree(void))
	m_Octree.SetManagerTexture(ManagerTexture);
	m_Octree.Build(m_VecMesh);
UnGuard
}

void ExCMap::BuildVertexArrays(void)
{
Guard(void ExMap::BuildVertexArrays(void))
	/*int i=0;
	float   *g_vertexArray;    // vertex array
	//float   *g_colorArray;     // color array
	float   *g_texcoordArray;  // texture array

	g_vertexArray= new float[m_VecMesh.size()*3][3];
	//g_colorArray=  new float[m_VecMesh.size()*3][3];
	g_texcoordArray= new float[m_VecMesh.size()*3][2];

	for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
	{
		//ManagerTexture->SetActiveTexture(m_ItVecMesh->GetMaterial());
		
		g_texcoordArray[i][0]=m_ItVecMesh->A.GetU(); 
		g_texcoordArray[i][1]=m_ItVecMesh->A.GetV();

		g_vertexArray[i][0]=m_ItVecMesh->A.GetX();
		g_vertexArray[i][0]=m_ItVecMesh->A.GetY();
		g_vertexArray[i][0]=m_ItVecMesh->A.GetZ();
		
		g_texcoordArray[i+1][0]=m_ItVecMesh->B.GetU();
		g_texcoordArray[i+1][1]=m_ItVecMesh->B.GetV();
		
		g_vertexArray[i+1][0]=m_ItVecMesh->B.GetX();
		g_vertexArray[i+1][0]=m_ItVecMesh->B.GetY();
		g_vertexArray[i+1][0]=m_ItVecMesh->B.GetZ();

		g_texcoordArray[i+2][0]=m_ItVecMesh->C.GetU();
		g_texcoordArray[i+2][1]=m_ItVecMesh->C.GetV();
		
		g_vertexArray[i+2][0]=m_ItVecMesh->C.GetX();
		g_vertexArray[i+2][0]=m_ItVecMesh->C.GetY();
		g_vertexArray[i+2][0]=m_ItVecMesh->C.GetZ();
		
		i++;
	}
	// enable the vertex arrays being used
	glEnableClientState(GL_VERTEX_ARRAY);
	//glEnableClientState(GL_COLOR_ARRAY);
	glEnableClientState(GL_TEXTURE_COORD_ARRAY);
	  // pass the pointers to OpenGL
	glVertexPointer(3, GL_FLOAT, 0, g_vertexArray);
	//glColorPointer(3, GL_FLOAT, 0, g_colorArray);
	glTexCoordPointer(2, GL_FLOAT, 0, g_texcoordArray);*/
UnGuard
}

bool ExCMap::LoadMap(const char *FileName)
{
Guard(void ExCMap::LoadMap(const char *FileName))
 	char			ch;
	int				RetVal;	
	std::string		StBuffer;
	char			Buff[255];
	int				FileSize;
	ExCVertex		VertexBuff;
	ExCMesh			MeshBuff;
	int				MeshNumber=0;
	
	FILE *MapFile;
	memset(Buff,0,255);
#ifdef UNIX_SRC
	sprintf (Buff, PREFIX "/ExNihilo/Data/Modeles/%s", FileName);
#else
	sprintf(Buff,"../Data/Modeles/%s",FileName);
#endif
	MapFile=fopen(Buff,"r");
	
	if(!MapFile)
	{
		*Consol<<"File not found:"<<Buff<<std::endl;
		return false;
	}else
	{	
		*Consol<<"Loading map File :"<<FileName<<std::endl;

 		fseek(MapFile,0,SEEK_END);
		FileSize=ftell(MapFile);
		//Start of file
		fseek(MapFile,0,SEEK_SET);
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MapFile);
		}while(ch!='#');
		//reading file type;
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MapFile);
			StBuffer=StBuffer+ch;	
		}while(ch!='#');
		if(strcmp(StBuffer.data(),"map#")==0)
		{
		//read top skybox texture
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			m_STextureBoxNameTop=new char[strlen(StBuffer.data()-5)];
			memset(m_STextureBoxNameTop,0,strlen(StBuffer.data()-5));
			StBuffer.copy(m_STextureBoxNameTop,strlen(StBuffer.data())-4,0);
		//read bottom skybox texture
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			m_STextureBoxNameBottom=new char[strlen(StBuffer.data()-5)];
			memset(m_STextureBoxNameBottom,0,strlen(StBuffer.data()-5));
			StBuffer.copy(m_STextureBoxNameBottom,strlen(StBuffer.data())-4,0);
		//read front skybox texture
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			m_STextureBoxNameFront=new char[strlen(StBuffer.data()-5)];
			memset(m_STextureBoxNameFront,0,strlen(StBuffer.data()-5));
			StBuffer.copy(m_STextureBoxNameFront,strlen(StBuffer.data())-4,0);
		//read back skybox texture
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			m_STextureBoxNameBack=new char[strlen(StBuffer.data()-5)];
			memset(m_STextureBoxNameBack,0,strlen(StBuffer.data()-5));
			StBuffer.copy(m_STextureBoxNameBack,strlen(StBuffer.data())-4,0);
		//read left skybox texture
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			m_STextureBoxNameLeft=new char[strlen(StBuffer.data()-5)];
			memset(m_STextureBoxNameLeft,0,strlen(StBuffer.data()-5));
			StBuffer.copy(m_STextureBoxNameLeft,strlen(StBuffer.data())-4,0);
		//read right skybox texture
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			m_STextureBoxNameRight=new char[strlen(StBuffer.data()-5)];
			memset(m_STextureBoxNameRight,0,strlen(StBuffer.data()-5));
			StBuffer.copy(m_STextureBoxNameRight,strlen(StBuffer.data())-4,0);
			
		// read number of vertex
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			try
			{
				m_NumberVertex=atol(StBuffer.data());
			}catch(...)
			{
				m_NumberVertex=0;
			}
		// read vertex
#ifdef UNIX_SRC
			m_VecVertex.resize (m_NumberVertex + 2);
#endif
			std::cout << __LINE__ << std::endl;
			for(int i=0;i<m_NumberVertex;i++)
			{
				//read x
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
						RetVal=fread(&ch,sizeof(char),1,MapFile);
						StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				try
				{
					VertexBuff.SetX(atof(StBuffer.data()));
					//cout<<"X:"<<atof(StBuffer.data());
				}catch(...)
				{
					m_NumberMesh=0;
				}
			//read y
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				//StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				try
				{
					VertexBuff.SetY(atof(StBuffer.data()));
					//cout<<" Y:"<<atof(StBuffer.data());
				}catch(...)
				{
					VertexBuff.SetY(0);
				}
			//read z
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				//StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				try
				{
					VertexBuff.SetZ(atof(StBuffer.data()));
					//cout<<" Z:"<<atof(StBuffer.data())<<endl;
				}catch(...)
				{
					VertexBuff.SetZ(0);
				}
			//read u
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				try
				{
					VertexBuff.SetU(atof(StBuffer.data()));
				}catch(...)
				{
					VertexBuff.SetU(0);
				}
			//read v
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				try
				{
					VertexBuff.SetV(atof(StBuffer.data()));
				}catch(...)
				{
					VertexBuff.SetV(0);
				}
				m_VecVertex.push_back(VertexBuff);				
			}
		// read number of mesh
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
			try
			{
				m_NumberMesh=atol(StBuffer.data());
			}catch(...)
			{
				m_NumberMesh=0;
			}
		// read mesh
#ifdef UNIX_SRC
			m_VecMesh.resize (m_NumberMesh + 2);
#endif
			for(int j=0;j<m_NumberMesh;j++) {
			//read vertex a	number
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				try {
					MeshBuff.A=m_VecVertex.at(atoi(StBuffer.data()));
				} catch(...) {
					MeshBuff.A=(ExCVertex(0.0f,0.0f,0.0f));
				}
			//read vertex b	number
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				
				try {
					MeshBuff.B=m_VecVertex.at(atoi(StBuffer.data()));
				} catch(...) {
					MeshBuff.B=(ExCVertex(0.0f,0.0f,0.0f));
				}
			//read vertex c number
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				try {
					MeshBuff.C=m_VecVertex.at(atoi(StBuffer.data()));
				} catch(...) {
					MeshBuff.C=(ExCVertex(0.0f,0.0f,0.0f));
				}
			//read AB
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				try {
					MeshBuff.m_AB=atoi(StBuffer.data());
				} catch(...) {
					MeshBuff.m_AB=0;
				}
			//read BC
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				try {
					MeshBuff.m_BC=atoi(StBuffer.data());
				} catch(...) {
					MeshBuff.m_BC=0;
				}
			//read CA
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				try {
					MeshBuff.m_CA=atoi(StBuffer.data());
				} catch(...) {
					MeshBuff.m_CA=0;
				}
			//read material
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				MeshBuff.SetMaterial(StBuffer.data());
				ManagerTexture->AddTexture(StBuffer.data());
			//read smothing
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do {
					RetVal=fread(&ch,sizeof(char),1,MapFile);
					StBuffer=StBuffer+ch;
				} while(ch!='#');
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				StBuffer.erase(StBuffer.begin(),StBuffer.begin()+1);
				try {
					MeshBuff.m_Smoothing=atoi(StBuffer.data());
				} catch(...) {
					MeshBuff.m_Smoothing=0;
				}
				MeshBuff.m_MeshNumber=MeshNumber;
				MeshNumber++;
				m_VecMesh.push_back(MeshBuff);
			}
			
		}else
		{
			*Consol<<FileName<<"is not a valide map file"<<std::endl;
			return false;
		}
		
		fclose(MapFile);
		ManagerTexture->AddTexture(m_STextureBoxNameTop);
		ManagerTexture->SetActiveTexture(m_STextureBoxNameTop);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		ManagerTexture->AddTexture(m_STextureBoxNameBottom);
		ManagerTexture->SetActiveTexture(m_STextureBoxNameBottom);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		ManagerTexture->AddTexture(m_STextureBoxNameFront);
		ManagerTexture->SetActiveTexture(m_STextureBoxNameFront);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		ManagerTexture->AddTexture(m_STextureBoxNameBack);
		ManagerTexture->SetActiveTexture(m_STextureBoxNameBack);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		ManagerTexture->AddTexture(m_STextureBoxNameLeft);
		ManagerTexture->SetActiveTexture(m_STextureBoxNameLeft);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		ManagerTexture->AddTexture(m_STextureBoxNameRight);
		ManagerTexture->SetActiveTexture(m_STextureBoxNameRight);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
		BuildOctree();
		BuilList();
		BuildVertexArrays();
		BuildSkyBox();
		*Consol<<FileName<<" map file loaded with "<<m_NumberVertex<<" vertex and "<<m_NumberMesh<<" faces"<<std::endl;
	}
	return true;
UnGuard
}
