/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCObject.cpp,v 1.17 2002/08/01 19:37:50 binny Exp $
 *
 */

#include "ExCObject.h"

// Construction/Destruction

ExCObject::ExCObject()
{
	SetName("NoName");
	SetId(-1);
	m_Size=1.0;
	m_RefreshTime=0.01f;
	m_Life=0;
	m_StartingLife=glutGet(GLUT_ELAPSED_TIME)/1000;
	m_Mass=100;
	m_ShowInfo=false;
	m_CurrentObject=false;
	m_Velocity.SetValue(0.01f,0.0f,0.0f);
	m_Position.SetValue(0.0f,0.0f,0.0f);
	m_Gravity.SetValue(0.0f,0.0f,0.0f);
	m_Acceleration=0.0f;
	m_AngleX=0.0f;
	m_AngleY=0.0f;
	m_AngleZ=0.0f;
}

ExCObject::~ExCObject()
{

}

void ExCObject::SetName(const char * Name)
{
Guard(void ExCObject::SetName(char * Name))
	m_ObjectName = new char[strlen(Name)];
	sprintf(m_ObjectName,Name);
UnGuard
}

void ExCObject::Draw(void)
{
Guard(void ExCObject::Draw(void))
UnGuard
}  

void ExCObject::ShowInfo(void)
{
Guard(void ExCObject::ShowInfo(void))
	
	char *CIdName;
	char *CPosition;
	char *CVelocity;
	char *CAcceleration;
	char *CGravity;
	char *CLife;

	CIdName= new char[strlen("Name : Id:")+strlen(GetName())+7];
	sprintf(CIdName,"Name :%s Id:%ld",GetName(),GetId());

	CPosition= new char[strlen("Position X: Y: Z:")+30];
	sprintf(CPosition,"Position X:%f Y:%f Z:%f",m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());

	CVelocity= new char[strlen("Velocity X: Y: Z:")+30];
	sprintf(CVelocity,"Velocity X:%f Y:%f Z:%f",m_Velocity.GetX(),m_Velocity.GetY(),m_Velocity.GetZ());

	CGravity= new char[strlen("Gravity X: Y: Z:")+30];
	sprintf(CGravity,"Gravity X:%f Y:%f Z:%f",m_Gravity.GetX(),m_Gravity.GetY(),m_Gravity.GetZ());

	CAcceleration= new char[strlen("Acceleration :")+30];
	sprintf(CAcceleration,"Acceleration :%f",m_Acceleration);

	CLife= new char[strlen("Life :")+10];
	sprintf(CLife,"Life :%f",m_Life);

	EnterOrthoMode();
		glDisable(GL_LIGHTING);
		RenderBitmapString(500,500,(void *)GLUT_BITMAP_HELVETICA_12,CIdName);	
		RenderBitmapString(500,515,(void *)GLUT_BITMAP_HELVETICA_12,CPosition);
		RenderBitmapString(500,530,(void *)GLUT_BITMAP_HELVETICA_12,CVelocity);	
		RenderBitmapString(500,545,(void *)GLUT_BITMAP_HELVETICA_12,CAcceleration);	
		RenderBitmapString(500,560,(void *)GLUT_BITMAP_HELVETICA_12,CGravity);	
		RenderBitmapString(500,575,(void *)GLUT_BITMAP_HELVETICA_12,CLife);	
		glEnable(GL_LIGHTING);
	LeaveOrthoMode();
UnGuard
}  

void ExCObject::SetIdName(IdName idname)
{
	SetName(idname.second);
	SetId(idname.first);
}

void ExCObject::SetAngleX(float Angle)
{
	if(m_AngleX<0)m_AngleX=359;
	if(m_AngleX>359)m_AngleX=0;
}

void ExCObject::SetAngleY(float Angle)
{
	if(m_AngleY<0)m_AngleY=359;
	if(m_AngleY>359)m_AngleY=0;
}

void ExCObject::SetAngleZ(float Angle)
{
	if(m_AngleZ<0)m_AngleZ=359;
	if(m_AngleZ>359)m_AngleZ=0;
}

void ExCObject::SetManagerTexture(ExManagerTexture * Texture)
{
	ManagerTexture = Texture;
}

void ExCObject::Rotate(float angleX,float angleY,float angleZ)
{
	SetAngleX(angleX);
	SetAngleY(angleY);
	SetAngleZ(angleZ);
	Rotate();	
}

void ExCObject::Rotate(void)
{
	if(m_AngleX<0)m_AngleX=359;
	if(m_AngleX>359)m_AngleX=0;
	if(m_AngleY<0)m_AngleY=359;
	if(m_AngleY>359)m_AngleY=0;
	if(m_AngleZ<0)m_AngleZ=359;
	if(m_AngleZ>359)m_AngleZ=0;
	
	ExQuaternion quat;
	ExCMatrix4x4 Matr;
	ExCVec3D VecX,VecY,VecZ,VecDir;
	
	quat=GetQuaternionFromEuler(m_AngleX,m_AngleY,m_AngleZ);
	//Matr=GetMatrixFromQuaternion(quat);
	//Matr=GetMatrixFromEuler(m_AngleX,m_AngleY,m_AngleZ);
	
	/*VecX.m_Vector[0]=(float)Matr.m_Matrix[0];
	VecX.m_Vector[1]=(float)Matr.m_Matrix[1];
	VecX.m_Vector[2]=(float)Matr.m_Matrix[2];
	VecY.m_Vector[0]=(float)Matr.m_Matrix[4];
	VecY.m_Vector[1]=(float)Matr.m_Matrix[5];
	VecY.m_Vector[2]=(float)Matr.m_Matrix[6];
	VecZ.m_Vector[0]=(float)Matr.m_Matrix[8];
	VecZ.m_Vector[1]=(float)Matr.m_Matrix[9];
	VecZ.m_Vector[2]=(float)Matr.m_Matrix[10];

	VecDir.m_Vector[0]=VecX.GetVectorLenght();
	VecDir.m_Vector[1]=VecY.GetVectorLenght();
	VecDir.m_Vector[2]=VecZ.GetVectorLenght();
	VecDir=VecX+VecY+VecZ;
	std::cout<<"Angle X:"<<m_AngleX<<" Y:"<<m_AngleY<<" Z:"<<m_AngleZ<<std::endl;
	std::cout<<"Quater :"<<quat<<std::endl;
	std::cout<<"Matrice:"<<Matr<<std::endl;
	std::cout<<"vec   X:"<<VecX<<std::endl;
	std::cout<<"vec   Y:"<<VecY<<std::endl;
	std::cout<<"vec   Z:"<<VecZ<<std::endl;
	std::cout<<"vec dir:"<<VecDir<<std::endl;
	std::cout<<"vel bef:"<<m_Velocity<<std::endl;
	//std::cout<<"vec aft:"<<m_Velocity<<std::endl;
	

	m_Target.SetX((Cos[(int)m_AngleY]));
	m_Target.SetZ((Sin[(int)m_AngleY]));
	m_Target.SetY((Sin[(int)m_AngleX]));
	std::cout<<"vec target:"<<m_Target<<std::endl;*/
	//VecDir=GetAxisFromQuaternion(quat);
	//m_Velocity=m_Velocity*VecDir;
	//std::cout<<"vec dir:"<<VecDir<<std::endl;
	//std::cout<<"vec vel:"<<m_Velocity<<std::endl;
	
}

