/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCOctree.cpp,v 1.4 2002/06/16 00:51:11 binny Exp $
 *
 */

#include "ExCOctree.h"

ExCOctree::ExCOctree(void)
{
Guard(ExCOctree::ExCOctree(void))
	m_ShowOctreeSubdivision=true;
	m_SubDivisionLevel=1;
	A=NULL;
	B=NULL;
	C=NULL;
	D=NULL;
	E=NULL;
	F=NULL;
	G=NULL;
	H=NULL;
UnGuard
}

ExCOctree::ExCOctree(std::vector<ExCMesh> VecMesh)
{
Guard(ExCOctree::ExCOctree(std::vector<ExCMesh> VecMesh))
	ExCOctree();
	Build(VecMesh);
UnGuard
}

ExCOctree::~ExCOctree(void)
{
Guard(ExCOctree::~ExCOctree(void))

UnGuard
}

void ExCOctree::BuildFirstBox(void)
{
Guard(void ExCOctree::BuildFirstBox(void))
	//1 build the box search for min and max value 
	double MaxX,MaxY,MaxZ,MinX,MinY,MinZ;
	m_ItVecMesh=m_VecMesh.begin();
	MaxX=m_ItVecMesh->A.GetX();
	MinX=m_ItVecMesh->A.GetX();
	MaxY=m_ItVecMesh->A.GetY();
	MinY=m_ItVecMesh->A.GetY();
	MaxZ=m_ItVecMesh->A.GetZ();
	MinZ=m_ItVecMesh->A.GetZ();
	for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
	{
		if(m_ItVecMesh->A.GetX()<MinX){MinX=m_ItVecMesh->A.GetX();}
		if(m_ItVecMesh->A.GetX()>MaxX){MaxX=m_ItVecMesh->A.GetX();}
		if(m_ItVecMesh->B.GetX()<MinX){MinX=m_ItVecMesh->B.GetX();}
		if(m_ItVecMesh->B.GetX()>MaxX){MaxX=m_ItVecMesh->B.GetX();}
		if(m_ItVecMesh->C.GetX()<MinX){MinX=m_ItVecMesh->C.GetX();}
		if(m_ItVecMesh->C.GetX()>MaxX){MaxX=m_ItVecMesh->C.GetX();}
        
		if(m_ItVecMesh->A.GetY()<MinY){MinY=m_ItVecMesh->A.GetY();}
		if(m_ItVecMesh->A.GetY()>MaxY){MaxY=m_ItVecMesh->A.GetY();}
		if(m_ItVecMesh->B.GetY()<MinY){MinY=m_ItVecMesh->B.GetY();}
		if(m_ItVecMesh->B.GetY()>MaxY){MaxY=m_ItVecMesh->B.GetY();}
		if(m_ItVecMesh->C.GetY()<MinY){MinY=m_ItVecMesh->C.GetY();}
		if(m_ItVecMesh->C.GetY()>MaxY){MaxY=m_ItVecMesh->C.GetY();}

		if(m_ItVecMesh->A.GetZ()<MinZ){MinZ=m_ItVecMesh->A.GetZ();}
		if(m_ItVecMesh->A.GetZ()>MaxZ){MaxZ=m_ItVecMesh->A.GetZ();}
		if(m_ItVecMesh->B.GetZ()<MinZ){MinZ=m_ItVecMesh->B.GetZ();}
		if(m_ItVecMesh->B.GetZ()>MaxZ){MaxZ=m_ItVecMesh->B.GetZ();}
		if(m_ItVecMesh->C.GetZ()<MinZ){MinZ=m_ItVecMesh->C.GetZ();}
		if(m_ItVecMesh->C.GetZ()>MaxZ){MaxZ=m_ItVecMesh->C.GetZ();}
	}
	
	
	//2 search for max segment
	
	if((MaxX-MinX)>=(MaxY-MinY)&&(MaxX-MinX)>=(MaxZ-MinZ))
	{
		maxsegment=MaxX-MinX;
	}
	if((MaxY-MinY)>=(MaxX-MinX)&&(MaxY-MinY)>=(MaxZ-MinZ))
	{
		maxsegment=MaxY-MinY;
	}
	if((MaxZ-MinZ)>=(MaxY-MinY)&&(MaxZ-MinZ)>=(MaxX-MinX))
	{
		maxsegment=MaxZ-MinZ;
	}
	//3 serach for center 
	m_GLobalBox.m_Center.SetX(((MaxX-MinX)/2)-maxsegment/2);
	m_GLobalBox.m_Center.SetY(((MaxY-MinY)/2)-maxsegment/2);
	m_GLobalBox.m_Center.SetZ(((MaxZ-MinZ)/2));
	//4 build a cube with max segment long around the center
	BuildBox(m_GLobalBox.m_Center,maxsegment);

UnGuard
}

void ExCOctree::BuildBox(ExCVertex center,double size)
{
Guard(void ExCOctree::BuildBox(ExCVertex center,double size))
	maxsegment=size;
	m_GLobalBox.m_Center=center;
    
	m_GLobalBox.m_Vertex[0].SetX(center.GetX()+(size/2));
	m_GLobalBox.m_Vertex[0].SetY(center.GetY()+(size/2));
	m_GLobalBox.m_Vertex[0].SetZ(center.GetZ()-(size/2));
	m_GLobalBox.m_Vertex[1].SetX(center.GetX()+(size/2));						
	m_GLobalBox.m_Vertex[1].SetY(center.GetY()+(size/2));
	m_GLobalBox.m_Vertex[1].SetZ(center.GetZ()+(size/2));
	m_GLobalBox.m_Vertex[2].SetX(center.GetX()-(size/2));
	m_GLobalBox.m_Vertex[2].SetY(center.GetY()+(size/2));
	m_GLobalBox.m_Vertex[2].SetZ(center.GetZ()+(size/2));
	m_GLobalBox.m_Vertex[3].SetX(center.GetX()-(size/2));
	m_GLobalBox.m_Vertex[3].SetY(center.GetY()+(size/2));
	m_GLobalBox.m_Vertex[3].SetZ(center.GetZ()-(size/2));
	m_GLobalBox.m_Vertex[4].SetX(center.GetX()+(size/2));
	m_GLobalBox.m_Vertex[4].SetY(center.GetY()-(size/2));
	m_GLobalBox.m_Vertex[4].SetZ(center.GetZ()-(size/2));
	m_GLobalBox.m_Vertex[5].SetX(center.GetX()+(size/2));
	m_GLobalBox.m_Vertex[5].SetY(center.GetY()-(size/2));
	m_GLobalBox.m_Vertex[5].SetZ(center.GetZ()+(size/2));
	m_GLobalBox.m_Vertex[6].SetX(center.GetX()-(size/2));
	m_GLobalBox.m_Vertex[6].SetY(center.GetY()-(size/2));
	m_GLobalBox.m_Vertex[6].SetZ(center.GetZ()+(size/2));
	m_GLobalBox.m_Vertex[7].SetX(center.GetX()-(size/2));
	m_GLobalBox.m_Vertex[7].SetY(center.GetY()-(size/2));
	m_GLobalBox.m_Vertex[7].SetZ(center.GetZ()-(size/2));

	/*std::cout<<"0:";m_GLobalBox.m_Vertex[0].Affich();std::cout<<std::endl;
	std::cout<<"1:";m_GLobalBox.m_Vertex[1].Affich();std::cout<<std::endl;
	std::cout<<"2:";m_GLobalBox.m_Vertex[2].Affich();std::cout<<std::endl;
	std::cout<<"3:";m_GLobalBox.m_Vertex[3].Affich();std::cout<<std::endl;
	std::cout<<"4:";m_GLobalBox.m_Vertex[4].Affich();std::cout<<std::endl;
	std::cout<<"5:";m_GLobalBox.m_Vertex[5].Affich();std::cout<<std::endl;
	std::cout<<"6:";m_GLobalBox.m_Vertex[6].Affich();std::cout<<std::endl;
	std::cout<<"7:";m_GLobalBox.m_Vertex[7].Affich();std::cout<<std::endl;*/
UnGuard
}

void ExCOctree::SubDivise(void)
{
Guard(void ExCOctree::SubDivise(void))
		ExCVertex	VertexTmp;
		A=new ExCOctree();
		A->SetSubDivisionLevel(m_SubDivisionLevel+1);
		A->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetY()+maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()+maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()+maxsegment/4);
		A->BuildBox(VertexTmp,maxsegment/2);
		
		B=new ExCOctree();
		B->SetSubDivisionLevel(m_SubDivisionLevel+1);
		B->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetX()+maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()+maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()-maxsegment/4);
		B->BuildBox(VertexTmp,maxsegment/2);
		
		C=new ExCOctree();
		C->SetSubDivisionLevel(m_SubDivisionLevel+1);
		C->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetX()-maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()+maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()-maxsegment/4);
		C->BuildBox(VertexTmp,maxsegment/2);
		
		D=new ExCOctree();
		D->SetSubDivisionLevel(m_SubDivisionLevel+1);
		D->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetX()-maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()+maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()+maxsegment/4);
		D->BuildBox(VertexTmp,maxsegment/2);
		
		/*E=new ExCOctree();
		E->SetSubDivisionLevel(m_SubDivisionLevel+1);
		E->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetX()+maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()-maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()+maxsegment/4);
		E->BuildBox(VertexTmp,maxsegment/2);
		
		F=new ExCOctree();
		F->SetSubDivisionLevel(m_SubDivisionLevel+1);
		F->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetX()+maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()-maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()-maxsegment/4);
		F->BuildBox(VertexTmp,maxsegment/2);
		
		G=new ExCOctree();
		G->SetSubDivisionLevel(m_SubDivisionLevel+1);
		G->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetX()-maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()-maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()-maxsegment/4);
		G->BuildBox(VertexTmp,maxsegment/2);
		
		H=new ExCOctree();
		H->SetSubDivisionLevel(m_SubDivisionLevel+1);
		H->SetManagerTexture(ManagerTexture);
		VertexTmp.SetX(m_GLobalBox.m_Center.GetX()-maxsegment/4);
		VertexTmp.SetY(m_GLobalBox.m_Center.GetY()-maxsegment/4);
		VertexTmp.SetZ(m_GLobalBox.m_Center.GetZ()+maxsegment/4);
		H->BuildBox(VertexTmp,maxsegment/2);
		*/
		int i=0;
		for(m_ItVecMesh=m_VecMesh.begin(),i=0;m_ItVecMesh!=m_VecMesh.end();m_ItVecMesh++,i++)
		{
			//std::cout<<"Iter :"<<i<<" Mesh :"<<m_ItVecMesh->m_MeshNumber<<" Level :"<<m_SubDivisionLevel<<"Stay :"<<m_VecMesh.size()<<std::endl;
			if(MeshInOctree(*m_ItVecMesh,A))
			{
				A->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}
			if(MeshInOctree(*m_ItVecMesh,B))
			{
				B->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}
			if(MeshInOctree(*m_ItVecMesh,C))
			{
				C->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}
			if(MeshInOctree(*m_ItVecMesh,D))
			{
				D->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}
			/*if(MeshInOctree(*m_ItVecMesh,E))
			{
				E->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}
			if(MeshInOctree(*m_ItVecMesh,F))
			{
				F->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}
			if(MeshInOctree(*m_ItVecMesh,G))
			{
				G->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}
			if(MeshInOctree(*m_ItVecMesh,H))
			{
				H->m_VecMesh.push_back(*m_ItVecMesh);
				//m_VecMesh.erase(m_ItVecMesh);
				continue;
			}	*/
			
        }
		
		std::cout<<"Level :"<<m_SubDivisionLevel<<"Stay :"<<m_VecMesh.size()<<std::endl;
		if(m_VecMesh.size()>0)
		{
			BuilList();	
		}

		if(A->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for A deleting A"<<std::endl;
			A=NULL;
		}
		if(B->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for B deleting B"<<std::endl;
			B=NULL;
		}
		if(C->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for C deleting C"<<std::endl;
			C=NULL;
		}
		if(D->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for D deleting D"<<std::endl;
			D=NULL;
		}/*
		if(E->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for B deleting B"<<std::endl;
			E=NULL;
		}
		if(F->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for B deleting B"<<std::endl;
			F=NULL;
		}
		if(G->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for B deleting B"<<std::endl;
			G=NULL;
		}
		if(H->m_VecMesh.size()==0)
		{
			//std::cout<<"No Mesh for B deleting B"<<std::endl;
			H=NULL;
		}  */ 
        
		if(m_VecMesh.size()>MAX_MESH_IN_CUBE&&m_SubDivisionLevel<MAX_SUBDIVISION)//to many in cube 
		{
			if(A!=NULL)A->SubDivise();
			if(B!=NULL)B->SubDivise();
			if(C!=NULL)C->SubDivise();
			if(D!=NULL)D->SubDivise();
			if(E!=NULL)E->SubDivise();
			if(F!=NULL)F->SubDivise();
			if(G!=NULL)G->SubDivise();
			if(H!=NULL)H->SubDivise();
			
		}	
		else
		{
			BuilList();	
		}
UnGuard
}

bool ExCOctree::MeshInOctree(ExCMesh Mesh,ExCOctree *octree)
{
Guard(bool ExCOctree::MeshInOctree(ExCMesh Mesh,ExCOctree *octree))
	double MaxX,MaxY,MaxZ,MinX,MinY,MinZ;
	int cmptin=0;
	MaxX=octree->m_GLobalBox.m_Center.GetX()+(maxsegment/2);
	MinX=octree->m_GLobalBox.m_Center.GetX()-(maxsegment/2);
	MaxY=octree->m_GLobalBox.m_Center.GetY()+(maxsegment/2);
	MinY=octree->m_GLobalBox.m_Center.GetY()-(maxsegment/2);
	MaxZ=octree->m_GLobalBox.m_Center.GetZ()+(maxsegment/2);
	MinZ=octree->m_GLobalBox.m_Center.GetZ()-(maxsegment/2);
		
	if(Mesh.A.GetX()<=MaxX && Mesh.A.GetX()>=MinX)
	{
		if(Mesh.A.GetY()<=MaxY && Mesh.A.GetY()>=MinY)
		{
			if(Mesh.A.GetZ()<=MaxZ && Mesh.A.GetZ()>=MinZ)
			{
				cmptin++;//one point is in cube
			}
		}
	}

	if(Mesh.B.GetX()<=MaxX && Mesh.B.GetX()>=MinX)
	{
		if(Mesh.B.GetY()<=MaxY && Mesh.B.GetY()>=MinY)
		{
			if(Mesh.B.GetZ()<=MaxZ && Mesh.B.GetZ()>=MinZ)
			{
				cmptin++;//one point is in cube
			}
		}
	}

	if(Mesh.C.GetX()<=MaxX && Mesh.C.GetX()>=MinX)
	{
		if(Mesh.C.GetY()<=MaxY && Mesh.C.GetY()>=MinY)
		{
			if(Mesh.C.GetZ()<=MaxZ && Mesh.C.GetZ()>=MinZ)
			{
				cmptin++;//one point is in cube
			}
		}
	}

	if(cmptin>1)//2 points are in cube add this mesh to this cube
	{
		return true;
	}
	else return false;
UnGuard
}

void ExCOctree::Build(std::vector<ExCMesh> VecMesh)
{
Guard(void ExCOctree::Build(std::vector<ExCMesh> VecMesh))
	m_VecMesh=VecMesh;
	BuildBox(ExCVertex(),1000);
	if(m_VecMesh.size()>MAX_MESH_IN_CUBE&&m_SubDivisionLevel<MAX_SUBDIVISION)//to many in cube 
	{
		SubDivise();	
	}else
	{
		BuilList();	
	}

UnGuard
}

void ExCOctree::Draw(void)
{
Guard(void ExCOctree::Draw(void))
	Frustrum.CalculateFrustum();
	
	if(Frustrum.CubeInFrustum(m_GLobalBox.m_Center.GetX(),m_GLobalBox.m_Center.GetY(),m_GLobalBox.m_Center.GetZ(),maxsegment))
	{
		if(m_ShowOctreeSubdivision)
		{
			if(m_SubDivisionLevel%1==0){glColor3f((float)m_SubDivisionLevel/10,1.0f-((float)m_SubDivisionLevel/10),1.0f);}
			if(m_SubDivisionLevel%2==0){glColor3f(1.0f,1.0f-((float)m_SubDivisionLevel/10),(float)m_SubDivisionLevel/10);}
			if(m_SubDivisionLevel%3==0){glColor3f(1.0f-((float)m_SubDivisionLevel/10),1.0f,(float)m_SubDivisionLevel/10);}
			m_GLobalBox.Draw();
		}
		glCallList(m_GlListId);
		//DRAW CHILD
		if(A!=NULL)A->Draw();
		if(B!=NULL)B->Draw();
		if(C!=NULL)C->Draw();
		if(D!=NULL)D->Draw();
		if(E!=NULL)E->Draw();
		if(F!=NULL)F->Draw();
		if(G!=NULL)G->Draw();
		if(H!=NULL)H->Draw();
	}
	
UnGuard
}

void ExCOctree::BuilList(void)
{
Guard(void ExMap::BuilList(void))
	m_GlListId=glGenLists(1);
	glNewList(m_GlListId,GL_COMPILE);
		glColor3f(1.0f, 1.0f, 1.0f);
		glDisable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
		int i=0;
		
		for(m_ItVecMesh=m_VecMesh.begin();m_ItVecMesh!=m_VecMesh.end();++m_ItVecMesh)
		{
			ManagerTexture->SetActiveTexture(m_ItVecMesh->GetMaterial());
			glBegin(GL_TRIANGLES);
			/*if(m_ItVecMesh->m_MeshNumber%2==1)//impair
			{
				glTexCoord2f(0.0f,0.0f);
			}else
			{
				glTexCoord2f(1.0f,1.0f);
			}*/
			glTexCoord2f(m_ItVecMesh->A.GetU(), m_ItVecMesh->A.GetV());
			glVertex3f(m_ItVecMesh->A.GetX(),m_ItVecMesh->A.GetY(),m_ItVecMesh->A.GetZ());
			/*if(m_ItVecMesh->m_MeshNumber%2==1)//impair
			{
				glTexCoord2f(1.0f,0.0f);
			}else
			{
				glTexCoord2f(0.0f,1.0f);
			} */ 
			glTexCoord2f(m_ItVecMesh->B.GetU(), m_ItVecMesh->B.GetV());
			glVertex3f(m_ItVecMesh->B.GetX(),m_ItVecMesh->B.GetY(),m_ItVecMesh->B.GetZ());
			/*if(m_ItVecMesh->m_MeshNumber%2==1)//impair
			{
				glTexCoord2f(1.0f,1.0f);
			}else
			{
				glTexCoord2f(0.0f,0.0f);
			}*/
			glTexCoord2f(m_ItVecMesh->C.GetU(), m_ItVecMesh->C.GetV());
			glVertex3f(m_ItVecMesh->C.GetX(),m_ItVecMesh->C.GetY(),m_ItVecMesh->C.GetZ());
			glEnd();
			i++;
		}	
		glEnable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);
	glEndList();
UnGuard
}
