/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCParticule.cpp,v 1.21 2002/07/23 11:19:01 data Exp $
 *
 */

#include "ExCParticule.h"

ExCParticule::ExCParticule(void)
{
Guard(ExCParticule::ExCParticule(void))
	m_LifeSpan=1000;
	m_Size=0.2;
	m_Weight=1;
	m_Mass=1;
	m_Type=PARTICULE_LINE;
	m_ColorR=255;
	m_ColorG=255;
	m_ColorB=255;
	m_Velocity.SetValue(0.0f,0.1f,0.0f);
	m_Position.SetValue(0.0f,0.0f,0.0f);
	m_Acceleration.SetValue(1.0f,1.0f,1.0f);
	m_Gravity.SetValue(0.0f,0.0f,0.0f);
UnGuard
}

ExCParticule::~ExCParticule(void)
{
Guard(ExCParticule::~ExCParticule(void))
UnGuard
}


void ExCParticule::SetParticuleType(int type)
{
Guard(void ExCParticule::SetParticuleType(int type))
	m_Type=type;
	if(m_Type>3)m_Type=1;
UnGuard
}

void ExCParticule::SetParticuleTexture(int texture)
{
Guard(void ExCParticule::SetParticuleTexture(int texture))
	m_Texture=texture;
UnGuard
}


void ExCParticule::Draw(void)
{
Guard(void ExCParticule::Draw(void))
	
	float x,y,z,x1,y1,z1;
	float GravityX,GravityY,GravityZ;
	int TimeNow=(m_TotalLife-m_LifeSpan);
	
	GLfloat no_mat[]			= {0.0f,0.0f,0.0f,1.0f};
	GLfloat mat_ambient[]		= {0.7f,0.7f,0.7f,1.0f};
	GLfloat mat_ambient_color[] = {0.8f,0.8f,0.2f,1.0f};
	GLfloat mat_diffuse[]		= {0.1f,0.5f,0.8f,1.0f};
	GLfloat mat_specular[]		= {1.0f,1.0f,1.0f,1.0f};
	GLfloat no_shininess[]		= {0.0f};
	GLfloat low_shininess[]		= {5.0f};
	GLfloat high_shininess[]	= {100.0f};
	GLfloat mat_emission[]		= {0.3f,0.2f,0.2f,0.0f};

	switch(m_Type)
	{
	case PARTICULE_POINT:

		glPushMatrix();

			glTranslatef(m_Position.m_Vector[0],
				m_Position.m_Vector[1],
				m_Position.m_Vector[2]);
			m_Position=m_Position+m_Velocity;

			glColor4ub(m_ColorR,m_ColorG,m_ColorB,m_Blending);
				glBegin(GL_POINT);
					glVertex3fv(m_Position.m_Vector);
				glEnd();
		glPopMatrix();
		break;

	case PARTICULE_LINE:
		glPushMatrix();

		GravityX=((TimeNow*TimeNow)*(m_Gravity.m_Vector[0])/20);
		GravityY=((TimeNow*TimeNow)*(m_Gravity.m_Vector[1])/20);
		GravityZ=((TimeNow*TimeNow)*(m_Gravity.m_Vector[2])/20);
				
		x=m_Position.m_Vector[0]+(m_Velocity.m_Vector[0]*TimeNow)-GravityX;
		y=m_Position.m_Vector[1]+(m_Velocity.m_Vector[1]*TimeNow)-GravityY;
		z=m_Position.m_Vector[2]+(m_Velocity.m_Vector[2]*TimeNow)-GravityZ;	

		x1=m_Position.m_Vector[0]+(m_Velocity.m_Vector[0]*(TimeNow+m_Size))-GravityX;
		y1=m_Position.m_Vector[1]+(m_Velocity.m_Vector[1]*(TimeNow+m_Size))-GravityY;
		z1=m_Position.m_Vector[2]+(m_Velocity.m_Vector[2]*(TimeNow+m_Size))-GravityZ;
		
		glTranslatef(x,y,z);
		glColor4ub(m_ColorR,m_ColorG,m_ColorB,m_Blending);
		
		glEnable(GL_BLEND);
		glEnable(GL_ALPHA);
		glBlendFunc(GL_ONE,GL_ONE);
		glEnable(GL_ALPHA_TEST);
		glAlphaFunc(GL_GREATER,0);
		glLineWidth(2.0f);
		//glEnable(GL_LIGHTING);
		
		glMaterialfv(GL_FRONT_AND_BACK,GL_AMBIENT,no_mat); 
		glMaterialfv(GL_FRONT_AND_BACK,GL_DIFFUSE,mat_diffuse); 
		glMaterialfv(GL_FRONT_AND_BACK,GL_SPECULAR,mat_specular); 
		glMaterialfv(GL_FRONT_AND_BACK,GL_SHININESS,high_shininess); 
		glMaterialfv(GL_FRONT_AND_BACK,GL_EMISSION,no_mat); 
		
		glBegin(GL_LINES);
			glVertex3f(x,y,z);	
			glVertex3f(x1,y1,z1);
		glEnd();
		glDisable(GL_LIGHTING);
		glDisable(GL_BLEND);
		glDisable(GL_ALPHA);
		glLineWidth(1.5);
		glPopMatrix();
		break;

	case PARTICULE_TEXTURE:
		glPushMatrix();
		ExCVec3D position;
		if(TimeNow<m_TotalLife)
		{
			position=m_VecPosition.at(TimeNow);
			glTranslatef(position.m_Vector[0],position.m_Vector[1],position.m_Vector[2]);
			// Orienation of particule
			GLfloat viewMatrix[16];
			glGetFloatv(GL_MODELVIEW_MATRIX, viewMatrix);
			ExCVec3D right;
			ExCVec3D up;

			right.SetValue(viewMatrix[0],viewMatrix[4],viewMatrix[8]);
			up.SetValue(viewMatrix[1],viewMatrix[5],viewMatrix[9]);

			ExCVec3D v1,v2,v3,v4;
			v1=m_Position+(right+up)*-m_Size;
			v2=m_Position+(right-up)*m_Size;
			v3=m_Position+(right+up)*m_Size;
			v4=m_Position+(up-right)*m_Size;

					
			//DRAW PARTICULE
			glColor4ub(m_ColorR,m_ColorG,m_ColorB,m_Blending);
			glEnable(GL_BLEND);
			glEnable(GL_ALPHA);
			glEnable(GL_TEXTURE_2D);
			glBlendFunc(GL_ONE,GL_ONE);
			glEnable(GL_ALPHA_TEST);
			glAlphaFunc(GL_GREATER,0);
			glDisable(GL_LIGHTING);
			glBindTexture(GL_TEXTURE_2D,m_Texture);
			glBegin(GL_QUADS);
				glTexCoord2f(0.0f, 0.0f); glVertex3fv(v1.m_Vector);
				glTexCoord2f(1.0f, 0.0f); glVertex3fv(v2.m_Vector);
				glTexCoord2f(1.0f, 1.0f); glVertex3fv(v3.m_Vector);
				glTexCoord2f(0.0f, 1.0f); glVertex3fv(v4.m_Vector);
			glEnd();
			glDisable(GL_TEXTURE_2D);
			glDisable(GL_BLEND);
			glDisable(GL_ALPHA);
			glEnable(GL_LIGHTING);
		}
		glPopMatrix();
		break;
	}
	
UnGuard
}

void ExCParticule::PrecalculeParticuleTrajectory(int start,int end)
{
Guard(void ExCParticule::PrecalculeParticuleTrajectory(int start,int end))
	float GravityX,GravityY,GravityZ;
	ExCVec3D Position;
	for(int i=start;i<end;i++)
	{
		GravityX=((i*i)*(m_Gravity.m_Vector[0])/2000);
		GravityY=((i*i)*(m_Gravity.m_Vector[1])/2000);
		GravityZ=((i*i)*(m_Gravity.m_Vector[2])/2000);
				
		Position.m_Vector[0]=m_Position.m_Vector[0]+(m_Velocity.m_Vector[0]*i)-GravityX;
		Position.m_Vector[1]=m_Position.m_Vector[1]+(m_Velocity.m_Vector[1]*i)-GravityY;
		Position.m_Vector[2]=m_Position.m_Vector[2]+(m_Velocity.m_Vector[2]*i)-GravityZ;	
		m_VecPosition.push_back(Position);
	}
UnGuard
}

void ExCParticule::ApplyForceToParitcule(ExCVec3D force)
{
Guard(void ExCParticule::ApplyForceToParitcule(ExCVec3D force))
	
UnGuard
}
