/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCSystemeParticule.cpp,v 1.30 2002/07/29 11:05:02 binny Exp $
 *
 */

#include "ExCSystemeParticule.h"

ExCSystemeParticule::ExCSystemeParticule(void)
{
Guard(ExCSystemeParticule::ExCSystemeParticule(void))
	m_MaxLifeSpan	= 1000;
	m_MinLifeSpan	= 100;
	m_MaxSize		= 0.3f;
	m_MinSize		= 0.00f;	
	m_MaxWeight		= 10;
	m_MinWeight		= 1;
	m_MaxColorR		= 255;
	m_MinColorR		= 0;
	m_MaxColorG		= 255;
	m_MinColorG		= 0;
	m_MaxColorB		= 255;
	m_MinColorB		= 0;
	m_MaxBlending	= 255;
	m_MinBlending	= 200;	
	m_MaxVelocity.SetValue(0.0f,1.0f,0.0f);
	m_MinVelocity.SetValue(0.0f,1.0f,0.0f);	
	m_MaxAcceleration.SetValue(0.0f,0.0f,0.0f);
	m_MinAcceleration.SetValue(0.0f,0.0f,0.0f);
	m_MaxGravity.SetValue(0.0f,0.0f,0.0f);
	m_MinGravity.SetValue(0.0f,0.0f,0.0f);
    m_Type				= PARTICULE_POINT;
	m_TimeLastParticule=0;

	m_MaxParticule	=10000;
	m_EmissionRate	=10;//in particule by seconde
	m_Pause=false;
	m_State=true;
	m_angle=5;
	m_rayon=3.0f;
	m_ParticuleSystemeName = new char[20];
	m_TypeEmmeteur=EMMETEUR_DISQUE;

	m_P1.SetValue(0.0f,0.0f,0.0f);
	m_P2.SetValue(10.0f,0.0f,0.0f);


UnGuard
}

ExCSystemeParticule::~ExCSystemeParticule(void)
{
Guard(ExCSystemeParticule::~ExCSystemeParticule(void))
UnGuard
}

void ExCSystemeParticule::SetParticuleSystemeName(char * name)
{
Guard(void ExCParticule::SetParticuleSystemeName(char * name))
	m_ParticuleSystemeName=new char[strlen(name)];
	strcpy(m_ParticuleSystemeName,name);
UnGuard
}

void ExCSystemeParticule::SetParticuleType(int type)
{
Guard(void ExCParticule::SetParticuleType(int type))
	m_Type=type;
	if(m_Type>3)m_Type=1;
UnGuard
}

void ExCSystemeParticule::SetParticuleTexture(char *texture)
{
Guard(void ExCParticule::SetParticuleTexture(char *texture))
	LoadTexture(texture);
UnGuard
}

void ExCSystemeParticule::Draw(void)
{
Guard(void ExCSystemeParticule::Draw(void))
	
	ExCRandomNumber  Randomnum;
	double			 a,c;
	int				i;

	glPushMatrix();
		

	/*	Position.SetValue(a,0.0f,c);
		Position.SetValue(0.0f,0.0f,10.0f);
		Position.SetValue(Randomnum.getFloat(0.0f,100.0f),Randomnum.getFloat(0.0f,100.0f),0.0f);
*/
		ExCVec3D Position;

		
		switch(m_TypeEmmeteur)
		{
		case EMMETEUR_POINT	:
			Position=m_Position+m_P1;
			break;

		case EMMETEUR_LIGNE :
		case EMMETEUR_RECTANGLE :
		case EMMETEUR_CUBE :
			Position.SetValue(Randomnum.getFloat(m_P1.m_Vector[0],m_P2.m_Vector[0]),
								Randomnum.getFloat(m_P1.m_Vector[1],m_P2.m_Vector[1]),
								Randomnum.getFloat(m_P1.m_Vector[2],m_P2.m_Vector[2]));
			Position=m_Position+Position;
			break;

		case EMMETEUR_CERCLE :
			a=Cos[m_angle]*m_rayon;
			c=Sin[m_angle]*m_rayon;
			m_angle=Randomnum.getInt(0,360);
			Position.SetValue(a,0.0f,c);
			Position=m_Position+Position;
			break;

		case EMMETEUR_DISQUE :
			a=Cos[m_angle]*(Randomnum.getFloat(0.0f,m_rayon));
			c=Sin[m_angle]*(Randomnum.getFloat(0.0f,m_rayon));
			m_angle++;
			if(m_angle>360)m_angle=0;
			Position.SetValue(a,0.0f,c);
			Position=m_Position+Position;
			break;

		case EMMETEUR_SPIRAL :
			a=Cos[m_angle]*m_rayon;
			c=Sin[m_angle]*m_rayon;
			m_angle+=m_vitesseangle;
			if(m_angle>360)m_angle=0;
			Position.SetValue(a,0.0f,c);
			Position=m_Position+Position;
			break;
		}




		time_t ltime;
		time( &ltime );
		
		// create new particule
		if(!m_Pause)
		{
			if(m_TimeLastParticule<ltime)
			{
				ExCParticule Particule;
				ExCVec3D Velocity,Acceleration,Gravity;
				Particule.SetParticuleTexture(m_Texture);
				Particule.SetParticuleType(m_Type);
				Particule.SetParticulePosition(Position);
				Particule.SetParticuleLife(Randomnum.getInt(m_MinLifeSpan,m_MaxLifeSpan));
				Particule.SetParticuleWeight(Randomnum.getInt(m_MinWeight,m_MaxWeight));
				Particule.SetParticuleColorB(Randomnum.getInt(m_MinColorB,m_MaxColorB));
				Particule.SetParticuleColorG(Randomnum.getInt(m_MinColorG,m_MaxColorG));
				Particule.SetParticuleColorR(Randomnum.getInt(m_MinColorR,m_MaxColorR));
				Particule.SetParticuleBlending(Randomnum.getInt(m_MinBlending,m_MaxBlending));
				Particule.SetParticuleMass(1.0f);
				//Particule.SetParticuleSize(Randomnum.getFloat (m_MinSize,m_MaxSize));
				Velocity.m_Vector[0]=Randomnum.getFloat(m_MaxVelocity.m_Vector[0],m_MinVelocity.m_Vector[0]);
				Velocity.m_Vector[1]=Randomnum.getFloat(m_MaxVelocity.m_Vector[1],m_MinVelocity.m_Vector[1]);
				Velocity.m_Vector[2]=Randomnum.getFloat(m_MaxVelocity.m_Vector[2],m_MinVelocity.m_Vector[2]);
				Particule.SetParticuleVelocity(Velocity);
				Acceleration.m_Vector[0]=Randomnum.getFloat(m_MaxAcceleration.m_Vector[0],m_MinAcceleration.m_Vector[0]);
				Acceleration.m_Vector[1]=Randomnum.getFloat(m_MaxAcceleration.m_Vector[1],m_MinAcceleration.m_Vector[1]);
				Acceleration.m_Vector[2]=Randomnum.getFloat(m_MaxAcceleration.m_Vector[2],m_MinAcceleration.m_Vector[2]);
				Particule.SetParticuleAcceleration(Acceleration);
				Gravity.m_Vector[0]=Randomnum.getFloat(m_MaxGravity.m_Vector[0],m_MinGravity.m_Vector[0]);
				Gravity.m_Vector[1]=Randomnum.getFloat(m_MaxGravity.m_Vector[1],m_MinGravity.m_Vector[1]);
				Gravity.m_Vector[2]=Randomnum.getFloat(m_MaxGravity.m_Vector[2],m_MinGravity.m_Vector[2]);
				Particule.SetParticuleGravity(Gravity);
				Particule.PrecalculeParticuleTrajectory(0,Particule.GetParticuleLife());
				m_VecParticule.push_back(Particule);
				//m_TimeLastParticule=ltime + m_EmissionRate;
				//std::cout<<"Create new particule"<<std::endl;			
			}
		}
	glPopMatrix();
	
	//draw all particule and destrou particule 
	//std::cout<<"Nombre particule :"<<m_VecParticule.size()<<std::endl;		
	if(m_VecParticule.size()>0)
	{
		
		for(i=0,m_ItVecParticule=m_VecParticule.begin();(unsigned)i<m_VecParticule.size();m_ItVecParticule++,i++)
		{
			//std::cout<<"particule :"<<i<<std::endl;		
			m_ItVecParticule->Draw();
			if(!m_Pause)m_ItVecParticule->DecreaseLifeSpan();
			if(!m_State)m_ItVecParticule->DecreaseLifeSpan();
			if(m_ItVecParticule->GetParticuleLife()<0)
			{
				m_VecParticule.erase(m_ItVecParticule);
			}
		}
	}
	//std::cout<<"add draw particule"<<std::endl;			
UnGuard
}

bool ExCSystemeParticule::LoadTexture(const char * name)
{
Guard(ExCSystemeParticule::LoadTexture(const char * name))
	char * filename;
	char buffer[255];
	
	filename = new char[strlen(name)+80];
#ifdef UNIX_SRC
	sprintf(filename, PREFIX "/ExNihilo/Data/Textures/%s.bmp",name);   //change path here if textures path change
#else
	sprintf(filename,"../Data/Textures/%s.bmp",name);   //change path here if textures path change
#endif

	
		//---------------------------------------------
		Image *image = new Image();
		FILE *file;
		unsigned long size;                 // size of the image in bytes.
		unsigned long i;                    // standard counter.
		unsigned short int planes;          // number of planes in image (must be 1) 
		unsigned short int bpp;             // number of bits per pixel (must be 24)
		char temp;                          // temporary color storage for bgr-rgb conversion.

		// make sure the file is there.
		if ((file = fopen(filename, "rb"))==NULL)
		{
			sprintf(buffer,"File Not Found : %s",filename);
			WriteToConsol(buffer);
			return false;
		}
#ifdef UNIX_SRC
		unsigned short int is_bmp;
		if (! fread (&is_bmp, sizeof (short int), 1, file)) {
			sprintf(buffer,"cannot read %s.\n", filename);
			WriteToConsol(buffer);
			return false;
		}
		
		/* check if file is a bitmap */
		if (is_bmp != 19778) {
			sprintf(buffer,"%s is not a valid bmp file.\n", filename);
			WriteToConsol(buffer);
			return false;
		}
		
		fseek (file, 8, SEEK_CUR);
		/* get the position of the actual bitmap data */
		long int bfOffBits;
		if (! fread (&bfOffBits, sizeof (long int), 1, file)) {
			sprintf(buffer,"Error reading %s.\n", filename);
			WriteToConsol(buffer);
			return false;
		}
		sprintf(buffer,"Data at offset: %ld .\n", bfOffBits);
		WriteToConsol(buffer);
		
		// seek through the bmp header, up to the width/height:
		fseek(file, 4, SEEK_CUR);
#else
		fseek(file, 18, SEEK_SET);
#endif
		// read the width
		if ((i = fread(&image->sizeX, 4, 1, file)) != 1) 
		{
			sprintf(buffer,"Error reading width from %s.\n", filename);
			WriteToConsol(buffer);
			return false;
		}
			    
		// read the height 
		if ((i = fread(&image->sizeY, 4, 1, file)) != 1) 
		{
			sprintf(buffer,"Error reading height from %s.\n", filename);
			WriteToConsol(buffer);
			return false;
		}
		
	    
		// calculate the size (assuming 24 bits or 3 bytes per pixel).
		size = image->sizeX * image->sizeY * 3;

		// read the planes
		if ((fread(&planes, 2, 1, file)) != 1)
		{
			sprintf(buffer,"Error reading planes from %s.\n", filename);
			WriteToConsol(buffer);
			return false;
		}

		if (planes != 1) 
		{
			sprintf(buffer,"Planes from %s is not 1: %u \n", filename, planes);
			WriteToConsol(buffer);
			return false;
		}

		// read the bpp
		if ((i = fread(&bpp, 2, 1, file)) != 1) 
		{
			sprintf(buffer,"Error reading bpp from %s.\n", filename);
			WriteToConsol(buffer);
			return false;
		}
		if (bpp != 24) 
		{
			sprintf(buffer,"Bpp from %s is not 24: %u\n", filename, bpp);
			WriteToConsol(buffer);
			return false;
		}
		
		// seek past the rest of the bitmap header.
		fseek(file, 24, SEEK_CUR);

		// read the data. 
		image->data = (char *) malloc(size);
		if (image->data == NULL)
		{
			sprintf(buffer,"Error allocating memory for color-corrected image data");
			WriteToConsol(buffer);
			return false;	
		}

		if ((i = fread(image->data, size, 1, file)) != 1) 
		{
			sprintf(buffer,"Error reading image data from %s.\n", filename);
			WriteToConsol(buffer);
			return false;
		}

		for (i=0;i<size;i+=3) 
		{ 
			// reverse all of the colors. (bgr -> rgb)
			temp = image->data[i];
			image->data[i] = image->data[i+2];
			image->data[i+2] = temp;
		}
		//---------------------------------------------
						
	
		glGenTextures(1,&m_Texture);

		glBindTexture(GL_TEXTURE_2D,m_Texture);

		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
		gluBuild2DMipmaps(GL_TEXTURE_2D, 3, image->sizeX, image->sizeY, GL_RGB, GL_UNSIGNED_BYTE, image->data);
		
		sprintf(buffer,"Particule syteme texture ok");
		WriteToConsol(buffer);
	return true;
UnGuard
}

void ExCSystemeParticule::Start(void)
{
Guard(void ExCSystemeParticule::Start(void))
	m_State=true;
	m_Pause=false;
UnGuard
}

void ExCSystemeParticule::Pause(void)
{
Guard(void ExCSystemeParticule::Pause(void))
	m_Pause=true;
UnGuard
}

void ExCSystemeParticule::Stop(void)
{
Guard(void ExCSystemeParticule::Stop(void))
	m_Pause=true;
	m_State=false;
UnGuard
}

bool ExCSystemeParticule::LoadParticuleSysteme(const char * FileName)
{
Guard(bool ExCParticule::LoadParticuleSysteme(const char * FileName))
	SetParticuleTexture("star");
	m_Type=PARTICULE_TEXTURE;

	int i=0;
	char				ch;
	int					RetVal;
	int					FileSize;
	FILE				*MyFile;
	std::string			StBuffer;
	char				buffer[255],bufferbis[255];
	std::vector<float>	vecvalue;

	
	sprintf(buffer,"../Data/ParticuleSystem/%s",FileName);
	m_ParticuleSystemeName=new char[strlen(FileName)];
	sprintf(m_ParticuleSystemeName,"%s",FileName);
    
	MyFile=fopen (buffer,"r");
	if(!MyFile)
	{
		sprintf(bufferbis,"Particule syteme File not found:%s",buffer);
		WriteToConsol(bufferbis);
		return false;
	}else
	{
		sprintf(buffer,"Loading Particule systeme file :%s",FileName);
		WriteToConsol(buffer);
	
 		fseek(MyFile,0,SEEK_END);
		FileSize=ftell(MyFile);
		sprintf(bufferbis,"Size:%d",FileSize);
		WriteToConsol(bufferbis);
		//Start of file
		fseek(MyFile,0,SEEK_SET);
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
		}while(ch!='#');
		//reading file type;
		do
		{
			RetVal=fread(&ch,sizeof(char),1,MyFile);
			StBuffer=StBuffer+ch;	
		}while(ch!='#');
		if(strcmp(StBuffer.data(),"particulesystem#")==0)
		{
			for(i=0;i<44;i++)
			{
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
						RetVal=fread(&ch,sizeof(char),1,MyFile);
						StBuffer=StBuffer+ch;
				}while(ch!='#');
				
				StBuffer.erase(StBuffer.end()-1,StBuffer.end());
				
				try
				{
					vecvalue.push_back(atof(StBuffer.data()));
				}catch(...)
				{
					vecvalue.push_back(0);
				}
			}
			/*
			for(i=0;i<nombrealire;i++)
			{
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				do
				{
					RetVal=fread(&ch,sizeof(char),1,MyFile);
					StBuffer=StBuffer+ch;
				}while(ch!='#');
				StBuffer.erase(StBuffer.begin(),StBuffer.end());
				vecvalue.push_back(StBuffer);
			}*/

			//read texture for particule
			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				StBuffer=StBuffer+ch;
			}while(ch!='#');

			StBuffer.erase(StBuffer.begin(),StBuffer.end());
			do
			{
				RetVal=fread(&ch,sizeof(char),1,MyFile);
				StBuffer=StBuffer+ch;
			}while(ch!='#');
			StBuffer.erase(StBuffer.end()-1,StBuffer.end());
			
			SetParticuleTexture((char *)StBuffer.data());
			//-----------------------------------
			m_EmissionRate	= vecvalue.at(0);
			m_MaxParticule	= vecvalue.at(1);
			m_TypeEmmeteur  = vecvalue.at(2);
			m_P1.SetValue(vecvalue.at(3),vecvalue.at(4),vecvalue.at(5));
			m_P2.SetValue(vecvalue.at(6),vecvalue.at(7),vecvalue.at(8));
			m_rayon         = vecvalue.at(9);
			m_vitesseangle  = vecvalue.at(10);
			m_MaxLifeSpan	= vecvalue.at(11);
			m_MinLifeSpan	= vecvalue.at(12);
			m_MaxSize		= vecvalue.at(13);
			m_MinSize		= vecvalue.at(14);	
			m_MaxWeight		= vecvalue.at(15);
			m_MinWeight		= vecvalue.at(16);
			m_MaxColorR		= vecvalue.at(17);
			m_MinColorR		= vecvalue.at(18);
			m_MaxColorG		= vecvalue.at(19);
			m_MinColorG		= vecvalue.at(20);
			m_MaxColorB		= vecvalue.at(21);
			m_MinColorB		= vecvalue.at(22);
			m_MaxBlending	= vecvalue.at(23);
			m_MinBlending	= vecvalue.at(24);	
			m_MaxVelocity.SetValue(vecvalue.at(25),vecvalue.at(26),vecvalue.at(27));
			m_MinVelocity.SetValue(vecvalue.at(28),vecvalue.at(29),vecvalue.at(30));	
			m_MaxAcceleration.SetValue(vecvalue.at(31),vecvalue.at(32),vecvalue.at(33));
			m_MinAcceleration.SetValue(vecvalue.at(34),vecvalue.at(35),vecvalue.at(36));
			m_MaxGravity.SetValue(vecvalue.at(37),vecvalue.at(38),vecvalue.at(39));
			m_MinGravity.SetValue(vecvalue.at(40),vecvalue.at(41),vecvalue.at(42));
			
			m_Type				= vecvalue.at(43);
			
			return true;
		}else
		{
			sprintf(buffer,"%s is not a valide particule syteme file",FileName);
			WriteToConsol(buffer);
			return false;
		}
		fclose(MyFile);
	}

UnGuard
}

