/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCTexture.cpp,v 1.6 2002/07/31 12:10:31 data Exp $
 *
 */

#include "ExCTexture.h"


ExCTexture::ExCTexture(void)
{
Guard(ExCTexture::ExCTexture(void))
	SetFileName("NoName");
UnGuard
}

ExCTexture::ExCTexture(const char * name)
{
Guard(ExCTexture::ExCTexture(const char * name))
	SetFileName(name);
UnGuard
}

ExCTexture::~ExCTexture(void)
{
Guard(ExCTexture::~ExCTexture(void))
UnGuard
}

void ExCTexture::SetFileName(const char * name)
{
Guard(void ExCTexture::SetFileName(const char * name))
	std::string FileName(name);
	if(FileName.find(".")<FileName.length())//if extension remove them
	{
		m_FileName=new char[strlen(name)-4];
		memset(m_FileName,0,strlen(name)-4);
		FileName.erase(FileName.find("."),FileName.length()-FileName.find("."));
		sprintf(m_FileName,"%s",FileName.data());
	}else
	{
		m_FileName=new char[strlen(name)];
		sprintf(m_FileName,"%s",name);
		//std::cout<<"filename:"<<m_FileName<<std::endl;
	}
UnGuard
}

char *ExCTexture::GetFileName(void)
{
Guard(char *ExCTexture::GetFileName(void))
	return m_FileName;
UnGuard
}

void ExCTexture::SetActive(void)
{
Guard(ExCTexture::SetActive(void))
	
	glBindTexture(GL_TEXTURE_2D,m_Texture);
UnGuard
}
