/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExPredefinedObject.cpp,v 1.5 2002/07/02 15:40:32 data Exp $
 *
 */

#include "ExPredefinedObject.h"

void InitBasicObjectList(void)
{
	float i;	
	glNewList(GRILLE,GL_COMPILE);
	glDisable(GL_LIGHTING);
	glBegin(GL_LINES);
		glColor3f(1.0f,0.0f,0.0f);
		for ( i=-100;i<101;i++)
		{	
			glVertex3f(0.0f,      i, 100.0f);
			glVertex3f(0.0f,      i,-100.0f);
			glVertex3f(0.0f, 100.0f,      i);
			glVertex3f(0.0f,-100.0f,      i);
		}
		glColor3f(0.0,1.0f,0.0f);
		
		for ( i=-100;i<101;i++)
		{
			glVertex3f( 100.0f,     i,0.0f);
			glVertex3f(-100.0f,     i,0.0f);
			glVertex3f(     i, 100.0f,0.0f);
			glVertex3f(     i,-100.0f,0.0f);
		}
		glColor3f(0.0,0.0f,1.0f);
		for (i=-100;i<101;i++)
		{
			glVertex3f( 100.0f,0.0f,      i);
			glVertex3f(-100.0f,0.0f,      i);
			glVertex3f(      i,0.0f, 100.0f);
			glVertex3f(      i,0.0f,-100.0f);
		}
	glEnd();
	glEnable(GL_LIGHTING);
	glEndList();


}

void RenderBitmapString(float x, float y, void *font,const char *string)
{
	const char *c;
	glRasterPos2f(x, y);
	for (c=string; *c != '\0'; c++)
	{
	   glutBitmapCharacter(font, *c);
	}
}

void EnterOrthoMode(void)
{
	glMatrixMode(GL_PROJECTION);						
	glPushMatrix();									
	glLoadIdentity();
	glOrtho( 0,glutGet(GLUT_WINDOW_WIDTH),glutGet(GLUT_WINDOW_HEIGHT),0,0,1);	
	glMatrixMode(GL_MODELVIEW);								
	glLoadIdentity();										
}

void LeaveOrthoMode(void)	
{
	glMatrixMode( GL_PROJECTION );							
	glPopMatrix();											
	glMatrixMode( GL_MODELVIEW );							
}
