/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCFile.cpp,v 1.10 2002/08/01 19:37:50 binny Exp $
 *
 */
 
#include "ExCFile.h"

void ExCFile::setOpenMode (int mode) {
	switch (mode) {
		case RO: this->mode = fstream::in; break;
		case WO: this->mode = fstream::out; break;
		case WOA: this->mode = fstream::out | fstream::app; break;
		case RW: this->mode = fstream::in | fstream::out; break;
		case RWA: this->mode = fstream::in | fstream::out | fstream::app; break;
		default: this->mode = fstream::in; break;
	}
}

ios_base::openmode ExCFile::getOpenMode (int mode) {
	switch (mode) {
		case RO: return ios::in; break;
		case WO: return ios::out; break;
		case WOA: return ios::out | ios::app; break;
		case RW: return ios::in | ios::out; break;
		case RWA: return ios::in | ios::out | ios::app; break;
		default: return ios::in; break;
	}
}

bool ExCFile::add (std::string f) {
	ofstream p;
	p.open (filename.data (), ios::app);
	if (p.fail ()) {
		std::cerr << "Erreur ouverture" << std::endl;
		return false;
	}
	p << f << std::endl;
	p.close ();
	return true;
}

bool ExCFile::addLine (void) {
	ofstream p;
	p.open (filename.data (), ios::app);
	if (p.fail ()) {
		std::cerr << "Erreur ouverture" << std::endl;
		return false;
	}
	p << std::endl;
	p.close ();
	return true;
}

ExCFile::~ExCFile () {
}

bool ExCFile::exist (void) {
	fstream file;
	file.open (filename.data(), getOpenMode (RO));
	if (! file.fail ()) {
		file.close();
		return true;
	}
	return false;
}

vector<string> ExCFile::getContent (void) {
	string d;
	vector<string> v;
	fstream file;
	file.open (filename.data (), getOpenMode (RO));
	if (! file.fail ()) {
		while (! std::getline (file, d).eof ()) {
			v.push_back (d);
		}
	}
	file.close ();
	return v;
}

ExCFileReader::ExCFileReader (string s) : ExCFile (s, RO) {
	file_data = new ExCFileData;
}

ExCFileData ExCFileReader::getContent (void) {
Guard(ExCFileData ExCFileReader::getContent (void))
	fstream file;
	if (file_data->getType() == FILE_EMPTY) {
		file.open (filename.data(), getOpenMode (RO));
		if (file.is_open ()) {
			string d;
			ExCFileDataAction ds;
			bool first = true;
			string action;
			while (! getline (file, d).eof ()) {
				if (first == false && (file_data->getType() != FILE_EMPTY || file_data->getType() != FILE_UNKNOWN)) {
					action = d.substr (0, d.find ("#"));
					#ifdef DEBUG_HIGH
					cout << "end of -> " << action.find ("end of") << endl;
					#endif
					if (action.find ("end of") != 0) {
						ds.setAction (action);
						#ifdef DEBUG_HIGH
						cout << "action -> " << d.substr (0, d.find ("#")) << endl;
						#endif
						if (file_data->getType() == FILE_COMMAND) {
							string dds = d.substr (d.find ("#") + 1, d.length());
							string dds1 = dds.substr (0, d.find ("#"));
							ds.setCommand (atoi ((dds1).data()));
							#ifdef DEBUG_HIGH
							cout << "command -> " << atoi (dds1.data()) << endl;
							#endif
							ds.setParam (dds.substr (dds.find ("#") + 1, d.length()));
							#ifdef DEBUG_HIGH
							cout << "param -> " << dds.substr (dds.find ("#") + 1, d.length()) << endl;
							#endif	
						} else {
							string dds = d.substr (d.find ("#") + 1, d.length());
							ds.setCommand (atoi ((dds).data()));
							#ifdef DEBUG_HIGH
							cout << "command -> " << atoi (d.substr (d.find ("#") + 1, d.length()).data()) << endl;
							#endif
						}
						file_data->addElement (ds);
					}
				} else {
					// erk
					int t = FILE_UNKNOWN;
					if (d == "#exec#") t = FILE_BATCH;
					else if (d == "#command#") t = FILE_COMMAND;
					else if (d == "#console#") t = FILE_CONSOLE;
					else if (d == "#set#") t = FILE_SET;
					else if (d == "#particulesystem#") t = FILE_PARTICULE;
					else if (d == "#interface#") t = FILE_INTERFACE;
					file_data->setType (t);
					#ifdef DEBUG_HIGH
					cout << "type -> " << d << " " << t << endl;
					#endif
					first = false;
				}
			}		
			file.close ();
		} else { cout << "pika plop !" << endl; }
	} else { cout << "plok ? plop !" << endl; }
	return *file_data;
UnGuard
}

ExCFileWriter::ExCFileWriter (string s) : ExCFile (s, WO) {};
	
void ExCFileWriter::setContent (ExCFileData s) {
	ofstream file;
	file.open (filename.data (), getOpenMode (WOA));
	vector<ExCFileDataAction> d = s.getContent();
	vector<ExCFileDataAction>::iterator i = d.begin ();
	string f = "#";
	switch (s.getType ()) {
		case FILE_BATCH: f += "exec"; break;
		case FILE_COMMAND: f += "command"; break;
		case FILE_CONSOLE: f += "console"; break;
		case FILE_SET: f += "set"; break;
		case FILE_PARTICULE: f += "particulesystem"; break;	
		case FILE_INTERFACE: f += "interface"; break;
	}
	f += "#";
	file << f << endl;
	
	ExCFileDataAction plop;
	while (i != d.end ()) {
		plop = *i++;
		file << plop.getAction() << "#" << plop.getCommand() << endl;
	}
	file.close ();
}
