/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCOptions.cpp,v 1.7 2002/08/06 16:52:59 binny Exp $
 *
 */

#include "ExCOptions.h"

ExCOptions::ExCOptions () {
	type_of_debug = EXC_NORMAL;
#ifdef UNIX_SRC
	std::string where = getenv ("HOME");
	where += EXNIHILO_REP_NAME;
	where += "/options";
	options_file = new ExCFile (where);
#endif
	
	// for the resolution
	resolution_x = 800;
	resolution_y = 600;
	depth = 16;
	rate = 75;
	
	fullscreen = "yes";
	fps = "yes";
	
	debug_style = EXC_NORMAL;
}

bool ExCOptions::create_options_file (void) {
#ifdef UNIX_SRC
	std::string where = getenv ("HOME");
	where += EXNIHILO_REP_NAME;

	// checking for the directory
	struct stat stbuf;
	if (stat (where.data (), &stbuf) == 0) {
		if (! S_ISDIR (stbuf.st_mode)) {
			std::cout << where << " is not a directory, please remove it !!!" 
							<< std::endl;
			return false;
		} else {
			std::cout << where << " created" << std::endl;
		}
	} else {
		if (mkdir (where.data (), 0755) != 0) {
			std::cout << "Can not create " << where << std::endl;
			return false;
		} else {
			std::cout << where << " created" << std::endl;
		}
	}
	// ok, now, we create the options file
	options_file->add ("# ExNihilo Options file");
	options_file->add ("# you can comment a line with '#'");
	options_file->addLine ();

	// DEBUG
	options_file->add ("# type of debug : NORMAL, DEBUG, TRACE, LOG");
	options_file->add ("# you need to compile ExNihilo with debug enabled to use this option");
	options_file->add ("debug.type: NORMAL");
	options_file->addLine ();

	// SCREEN
	options_file->add ("# resolution of the screen : format WidthxHeigth:bpp@frequency");
	options_file->add ("# WARNING: a too big frequency may damage your screen and/or video card");
	options_file->add ("screen.resolution: 800x600:16@75");
	options_file->addLine ();
	options_file->add ("# start in fullscreen ? [true|false]");
	options_file->add ("screen.fullscreen: yes");
	options_file->addLine ();
	options_file->add ("# show fps ? [true|false]");
	options_file->add ("screen.fps: yes");
	options_file->addLine ();

#endif // UNIX_SRC

	return true;
}

bool ExCOptions::init (void) {
#ifdef UNIX_SRC
	options_file->setOpenMode (RO);
	if (! options_file->exist ()) {
		create_options_file ();
	}
#endif
	load (EXC_OPTIONS_ALL);

	return true;
}

bool ExCOptions::load (int type) {
#ifdef UNIX_SRC
	options_file->setOpenMode (RO);
	// we take the content of the options file
	std::vector<std::string> v = options_file->getContent ();
	// we analyse this content
	std::vector<std::string>::iterator i = v.begin ();
	std::string analyze;
	while (i != v.end ()) {
		analyze = *i++;
		if (analyze[0] == '#') 
			// if line begin by # so it's a comment
			continue;
		else {
			if (analyze.find ('.') < analyze.size ()) {
				string type = analyze.substr (0, analyze.find ('.'));
				string under_type = analyze.substr (analyze.find ('.') + 1, analyze.size ());
				under_type = analyze.substr (analyze.find ('.') + 1, analyze.find (':') - analyze.find ('.') - 1);
				string value = analyze.substr (analyze.find (':') + 2, analyze.size ());
				
				if (type == "debug") {
					if (under_type == "type") {
						if (value == "NORMAL") 
							debug_style = EXC_NORMAL;
						else if (value == "DEBUG") 
							debug_style = EXC_DEBUG;
						else if (value == "TRACE") 
							debug_style = EXC_TRACE;
						else if (value == "LOG") 
							debug_style = EXC_LOG;
					}
				} else if (type == "screen") {
					if (under_type == "resolution") {
						resolution_x = atoi (value.substr (0, value.find ('x')).data ());
						value.erase (0, value.find ('x') + 1);
						resolution_y = atoi (value.substr (0, value.find (':')).data ());
						value.erase (0, value.find (':') + 1);
						depth = atoi (value.substr (0, value.find ('@')).data ());
						value.erase (0, value.find ('@') + 1);
						rate = atoi (value.data ());
					} else if (under_type == "fullscreen") {
						fullscreen = value;
					} else if (under_type == "fps") {
						fps = value;
					}
				}
			}
		}				
	}
#endif	
	return true;
}

bool ExCOptions::load (void) {
	return load (EXC_OPTIONS_ALL);
}

bool ExCOptions::reload (void) {
	return load (EXC_OPTIONS_RELOAD);
}

bool ExCOptions::getWindowFullscreen (void) { 
	return (fullscreen == "yes") ? true : false; 
}

bool ExCOptions::getWindowShowfps (void) { 
	return (fps == "yes") ? true : false; 
}
