/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCTime.cpp,v 1.4 2002/07/05 12:50:39 binny Exp $
 *
 */

#include "ExCTime.h"

ExCTime::ExCTime () {
	_long_t = -1;
}

bool ExCTime::start (float long_t) {
	if (long_t <= 0) return false;
	else {
		_long_t = long_t;
#ifdef UNIX_SRC
		_start = clock ();
#endif
		_real_t0 = time (NULL);
		return true;
	}
}

bool ExCTime::startBlock (float long_t) {
	if (long_t < 0) return false;
	else if (long_t == 0) return true;
	else {
		_long_t = long_t;
#ifdef UNIX_SRC
		_start = clock ();
#endif
		_real_t0 = time (NULL);
		time_t t1;
		do {
			t1 = time (NULL);
		} while (difftime (t1, _real_t0) < _long_t);
		return true;
	}
}

bool ExCTime::stop (void) {
#ifdef UNIX_SRC
	_finish = clock ();
#endif
	_real_t1 = time (NULL);
	return true;
}

bool ExCTime::isTimePassed (float long_t) {
	time_t t1 = time (NULL);
	if (difftime (t1, _real_t0) >= _long_t) return true;
	else return false;
}

bool ExCTime::isFinished (void) {
	time_t t1 = time (NULL);
	if (difftime (t1, _real_t0) >= _long_t) return true;
	else return false;
}

#ifdef UNIX_SRC
bool ExCTime::isClockTimePassed (float long_t) {
	clock_t f = clock ();
	if (((double) (f - _start) / CLOCKS_PER_SEC) >= long_t) return true;
	else return false;
}

bool ExCTime::isClockFinished (void) {
	clock_t f = clock ();
	if (((double) (f - _start) / CLOCKS_PER_SEC) >= _long_t) return true;
	else return false;
}
#endif
