/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCXMLParser.cpp,v 1.1 2002/08/01 19:37:51 binny Exp $
 *
 */
 
#include "ExCXMLParser.h"

#ifdef XML_TEST

ExCXMLAction::ExCXMLAction () {
	action = 0;
	command = "";
	sub = "";
	args = 0;
}

ExCXMLAction::~ExCXMLAction () {}
	
void ExCXMLAction::setAction (int a) { 
	action = a;
}

void ExCXMLAction::setCommand (string c) { 
	command = c; 
}

void ExCXMLAction::setSub (string s) { 
	sub = s; 
}

void ExCXMLAction::setArgs (int a) { 
	args = a;
}

void ExCXMLAction::add (string s) { 
	sarg.push_back (s); 
}

void ExCXMLAction::add (int i) { 
	iarg.push_back (i); 
}

int ExCXMLAction::getAction (void) { 
	return action; 
}

string ExCXMLAction::getCommand (void) { 
	return command; 
}

string ExCXMLAction::getSub (void) { 
	return sub;
}

int ExCXMLAction::getArgs (void) { 
	return args;
}

bool ExCXMLAction::isInt (void) {
	if (iarg.size () != 0) 
		return true;
	else return false;
}

bool ExCXMLAction::isString (void) {
	if (sarg.size () != 0) 
		return true;
	else return false;
}

vector<int> ExCXMLAction::getInt (void) { 
	return iarg; 
}

vector<string> ExCXMLAction::getString (void) { 
	return sarg; 
}

void ExCXMLAction::reset (void) {
	command = "";
	sub = "";
	iarg.clear ();
	sarg.clear ();
}

ExCXMLFileParse::ExCXMLFileParse () {}
ExCXMLFileParse::~ExCXMLFileParse () {}

void ExCXMLFileParse::setType (string t) {
	type = t;
}

string ExCXMLFileParse::getType (void) {
	return type;
}

vector<ExCXMLAction> ExCXMLFileParse::getParsing (void) {
	return _action;
}

void ExCXMLFileParse::add (ExCXMLAction f) {
	_action.push_back (f);
}

ExCXMLParser::ExCXMLParser () {}
ExCXMLParser::~ExCXMLParser () {}

// ok, it was funny 'till here ;)
ExCXMLFileParse ExCXMLParser::parse (ExCFileReader *file) {
	if (file->open ()) {
		vector<string> content = file->getContent ();
		vector<string>::iterator i = content.begin ();
		string t;
		
		ExCXMLAction tmp_action;
		
		while (i != content.end ()) {
			t = *i++;
			t = t.substr (t.find ("<") + 1);			
			
			switch (t[0]) {
				case '?': // <?xml .... 
					break;
				case 'f': {
					// <file type="type_of_file">					
					string type = t.substr (t.find ("type") + 6);
					type.erase (type.find ("\""));
					action_parsing.setType (type);
					break;
				}
				case 'c': {
					// <command name="name_of_command" sub="foo" action="12345"> action soon deprecated ?!
					string name = t.substr (t.find ("name") + 6);
					name.erase (name.find ("\""));
					tmp_action.setCommand (name);
					
					string sub = t.substr (t.find ("sub") + 5);
					sub.erase (sub.find ("\""));
					tmp_action.setSub (sub);
					
					string action = t.substr (t.find ("action") + 8);
					action.erase (action.find ("\""));
					tmp_action.setAction (atoi (action.data ()));
					break;
				}
				case 'a': {
					string targ = t.substr (t.find ("type") + 6);
					targ.erase (targ.find ("\""));
					
					if (targ != "null") {
						string arg = t.substr (t.find (">") + 1);
						arg.erase (arg.find ("<"));
												
						string narg = t.substr (t.find ("number") + 8);
						narg.erase (narg.find ("\""));
						int n_arg = atoi (narg.data ());
						tmp_action.setArgs (n_arg);
						
						for (int i = 0; i < n_arg; i++) {
							if (targ == "int") {
								tmp_action.add (atoi (arg.substr (0, arg.find(" ")).data ()));
							} else if (targ == "string") {
								tmp_action.add (arg.substr (0, arg.find(" ")));
							} else if (targ == "mix") {
							} else {
								cerr << "Problem in parser : " << targ << " : unknown type" << endl;
							}	
							arg = arg.substr (arg.find(" ") + 1);
						}
					}
					break;
				}
				case '/': {
					// </command> or </file>
					switch (t[1]) {
							case 'c': // </command>
								action_parsing.add (tmp_action);
								tmp_action.reset ();
								break;
							case 'f': // </file>
								file->close ();
								return action_parsing;
							default:								
								cerr << "Problem in parser : <" << t << " : unknown tag" << endl;
								break;
						}
					break;
				}
				default:
					cerr << "Problem in parser : <" << t << " : unknown tag" << endl;
					break;
			}
		}
		file->close ();
	}
	return action_parsing;
}

#endif // XML_TEST
