/************************************************************************/
/* Tutorial by Hermanns Christophe PlokSoftWare							*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* MSN Messenger    : Data@ploksoftware.org								*/
/*                                                                      */
/************************************************************************/

#pragma comment(lib, "OpenGL32.lib")
#pragma comment(lib, "GLu32.lib")
#pragma comment(lib, "glaux.lib")
#pragma comment(lib, "SDLmain.lib")
#pragma comment(lib, "SDL.lib")

//////////////////////////////////////////////////////////////////////////
//Includes
//////////////////////////////////////////////////////////////////////////
#ifdef WIN32
#include <windows.h>
#endif //WIN32
#include <GL/gl.h>		//Header OpenGl
#include <GL/glu.h>		//Header Glu toolkit OpenGl
#include <GL/glext.h>
#include <GL/glaux.h>	//header Glaux Library
#include <GL/wglext.h>
#include <SDL/SDL.h>
#include <stdio.h>
#include <math.h>
#include <float.h>
//////////////////////////////////////////////////////////////////////////
//Define
//////////////////////////////////////////////////////////////////////////
#define WINDOW_TITLE		"Tutorial GL_ARB_point_parameters by Hermanns Christophe PlokSoftWare"
#define NUMBER_PARTICLE		1200
#define MAX_PARTICLE_LIFE	500
//////////////////////////////////////////////////////////////////////////
//struct
//////////////////////////////////////////////////////////////////////////
struct Vec3D {
	float x,y,z;
};
struct Particle {
	Vec3D Position;
	Vec3D Color;
	Vec3D Velocity;
	int life;
};

//////////////////////////////////////////////////////////////////////////
//Variables
//////////////////////////////////////////////////////////////////////////
PFNGLPOINTPARAMETERFARBPROC  glPointParameterfARB  = NULL;
PFNGLPOINTPARAMETERFVARBPROC glPointParameterfvARB = NULL;
bool m_PointARBEnable = false;
SDL_Surface *g_pWindow;
Particle m_VecParticle[NUMBER_PARTICLE];
//////////////////////////////////////////////////////////////////////////
//Functions
//////////////////////////////////////////////////////////////////////////
void ResizeWindow (int iWidth, int iHeight);
void CheckForExtension(void);
void DrawARBPointSprites(Particle* VecParticle, int Number);
float getRandomMinMax( float fMin, float fMax );
//////////////////////////////////////////////////////////////////////////
//Main
//////////////////////////////////////////////////////////////////////////
int main (int argc, char* argv[])
{
	//////////////////////////////////////////////////////////////////////////
	//Init window
	//////////////////////////////////////////////////////////////////////////
	if (SDL_Init (SDL_INIT_VIDEO) < 0)
	{
		printf ("Error SDL_Init : %s", SDL_GetError ());
		SDL_Quit ();
		exit (0);
	}
	const SDL_VideoInfo *pVideoInfo = SDL_GetVideoInfo ();
	SDL_GL_SetAttribute (SDL_GL_DOUBLEBUFFER, 1);
	SDL_GL_SetAttribute (SDL_GL_DEPTH_SIZE, 24);
	SDL_GL_SetAttribute (SDL_GL_STENCIL_SIZE, 0);
	SDL_GL_SetAttribute (SDL_GL_ACCUM_RED_SIZE, 0);
	SDL_GL_SetAttribute (SDL_GL_ACCUM_GREEN_SIZE, 0);
	SDL_GL_SetAttribute (SDL_GL_ACCUM_BLUE_SIZE, 0);
	SDL_GL_SetAttribute (SDL_GL_ACCUM_ALPHA_SIZE, 0);
	if ((g_pWindow = SDL_SetVideoMode (800, 600, 32, SDL_OPENGL | SDL_HWPALETTE | SDL_HWSURFACE | SDL_HWACCEL)) == NULL)
	{
		printf ("Error SDL_SetVideoMode : %s\n", SDL_GetError());
		SDL_Quit ();
		exit (0);
	}

	SDL_WM_SetCaption (WINDOW_TITLE, WINDOW_TITLE);
	ResizeWindow (800, 600);
	//////////////////////////////////////////////////////////////////////////
	//Load Texture
	//////////////////////////////////////////////////////////////////////////
	AUX_RGBImageRec* texture;
	texture = auxDIBImageLoad((const char*)"particle.bmp");
	GLuint  m_Texture=0;
	glBindTexture(GL_TEXTURE_2D, m_Texture);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, texture->sizeX, texture->sizeY, 0, GL_RGB, GL_UNSIGNED_BYTE, texture->data);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);	// Linear Filtering
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);	// Linear Filtering
	//////////////////////////////////////////////////////////////////////////
	//Init particle
	//////////////////////////////////////////////////////////////////////////
	for(int i=0;i<NUMBER_PARTICLE;i++)
	{
		m_VecParticle[i].Color.x=getRandomMinMax(0.0f,1.0f);	
		m_VecParticle[i].Color.y=getRandomMinMax(0.0f,1.0f);
		m_VecParticle[i].Color.z=getRandomMinMax(0.0f,1.0f);
		m_VecParticle[i].Position.x=0.0;	
		m_VecParticle[i].Position.y=0.0;
		m_VecParticle[i].Position.z=0.0;
		m_VecParticle[i].Velocity.x=getRandomMinMax(-0.01f,0.01f);	
		m_VecParticle[i].Velocity.y=getRandomMinMax(-0.01f,0.01f);
		m_VecParticle[i].Velocity.z=getRandomMinMax(-0.01f,0.01f);
		m_VecParticle[i].life=0;
	}
	//////////////////////////////////////////////////////////////////////////
	//GL initialisation
	//////////////////////////////////////////////////////////////////////////
	glClearColor (0.0, 0.0, 0.0, 0.0);
	glShadeModel (GL_FLAT);
	glEnable (GL_CULL_FACE);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA,GL_ONE);	
	CheckForExtension();
	//////////////////////////////////////////////////////////////////////////
	//SDL event loop
	//////////////////////////////////////////////////////////////////////////
	while (1)
	{
		SDL_Event event;
		while (SDL_PollEvent (&event))
		{
			switch (event.type)
			{
			case SDL_QUIT:
			case SDL_KEYDOWN:
				SDL_Quit ();
				exit (0);
				break;
			}
		}
		//////////////////////////////////////////////////////////////////////////
		//Draw scene
		//////////////////////////////////////////////////////////////////////////
		glClear (GL_COLOR_BUFFER_BIT);
		glLoadIdentity ();
		gluLookAt (0, 4, 0, 0, 0, 0, 0, 0, 1);
		glBindTexture(GL_TEXTURE_2D, m_Texture);
		for(int i=0;i<NUMBER_PARTICLE;i++)
		{
			m_VecParticle[i].Position.x+=m_VecParticle[i].Velocity.x;
			m_VecParticle[i].Position.y+=m_VecParticle[i].Velocity.y;
			m_VecParticle[i].Position.z+=m_VecParticle[i].Velocity.z;
			m_VecParticle[i].life++;
			if(m_VecParticle[i].life>MAX_PARTICLE_LIFE)
			{
				m_VecParticle[i].life=0;
				m_VecParticle[i].Position.x=0;
				m_VecParticle[i].Position.y=0;
				m_VecParticle[i].Position.z=0;
			}
		}
		DrawARBPointSprites(m_VecParticle,NUMBER_PARTICLE);
		glPopMatrix ();
		SDL_GL_SwapBuffers ();
	}
}
float getRandomMinMax( float fMin, float fMax )
{
	float fRandNum = (float)rand () / RAND_MAX;
	return fMin + (fMax - fMin) * fRandNum;
}

void ResizeWindow (int iWidth, int iHeight)
{
	if (iHeight == 0)iHeight = 1;
	glViewport (0, 0, iWidth, iHeight);
	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluPerspective (45.f, (float)iWidth / (float)iHeight, 0.1f, 512);
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
}

void DrawARBPointSprites(Particle* VecParticle, int Number)
{
	float quadratic[] =  { 0.0f, 0.0f, 0.01f };
	glPointParameterfvARB( GL_POINT_DISTANCE_ATTENUATION_ARB, quadratic );
	float maxSize = 0.0f;
	glGetFloatv( GL_POINT_SIZE_MAX_ARB, &maxSize );
	glPointSize( maxSize );
	glPointParameterfARB( GL_POINT_SIZE_MAX_ARB, maxSize );
	glPointParameterfARB( GL_POINT_SIZE_MIN_ARB, 1.0f );
	glTexEnvf( GL_POINT_SPRITE_ARB, GL_COORD_REPLACE_ARB, GL_TRUE );
	glEnable( GL_POINT_SPRITE_ARB );
	glBegin( GL_POINTS );
	{
		for(int i=0;i<Number;i++)
		{
			glColor4f(VecParticle[i].Color.x,VecParticle[i].Color.y,VecParticle[i].Color.z,1.0f);
			glVertex3f(VecParticle[i].Position.x,VecParticle[i].Position.y,VecParticle[i].Position.z);
		}
	}
	glEnd();
	glDisable( GL_POINT_SPRITE_ARB );
}

void CheckForExtension(void)
{
	char *ext = (char*)glGetString( GL_EXTENSIONS );
	/////////////////////////////////////////////////////////////////
	//Looking for GL_ARB_point_parameters extension
	/////////////////////////////////////////////////////////////////
	if( strstr( ext, "GL_ARB_point_parameters" ) != NULL )
	{
		glPointParameterfARB  = (PFNGLPOINTPARAMETERFEXTPROC)wglGetProcAddress("glPointParameterfARB");
		glPointParameterfvARB = (PFNGLPOINTPARAMETERFVEXTPROC)wglGetProcAddress("glPointParameterfvARB");
		if( !glPointParameterfARB || !glPointParameterfvARB )
		{
			m_PointARBEnable=false;
		}
		m_PointARBEnable=true;
	}
}
